/*
 * Decompiled with CFR 0.152.
 */
package com.google.minijoe.sys;

import com.google.minijoe.sys.JsArray;
import com.google.minijoe.sys.JsDate;
import com.google.minijoe.sys.JsError;
import com.google.minijoe.sys.JsFunction;
import com.google.minijoe.sys.JsSystem;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;

public class JsObject {
    public static final int ID_NOOP = -1;
    protected static final int ID_INIT_OBJECT = 1;
    protected static final int ID_TO_STRING = 2;
    protected static final int ID_VALUE_OF = 3;
    protected static final int ID_TO_LOCALE_STRING = 4;
    protected static final int ID_HAS_OWN_PROPERTY = 5;
    protected static final int ID_IS_PROTOTYPE_OF = 6;
    protected static final int ID_PROPERTY_IS_ENUMERABLE = 7;
    static final int ID_PARSE_INT = 10;
    static final int ID_PARSE_FLOAT = 11;
    static final int ID_IS_NAN = 12;
    static final int ID_IS_FINITE = 13;
    static final int ID_DECODE_URI = 14;
    static final int ID_DECODE_URI_COMPONENT = 15;
    static final int ID_ENCODE_URI = 16;
    static final int ID_ENCODE_URI_COMPONENT = 17;
    static final int ID_PRINT = 18;
    static final int ID_ABS = 19;
    static final int ID_ACOS = 20;
    static final int ID_ASIN = 21;
    static final int ID_ATAN = 22;
    static final int ID_ATAN2 = 23;
    static final int ID_CEIL = 24;
    static final int ID_COS = 25;
    static final int ID_EXP = 26;
    static final int ID_FLOOR = 27;
    static final int ID_LOG = 28;
    static final int ID_MAX = 29;
    static final int ID_MIN = 30;
    static final int ID_POW = 31;
    static final int ID_RANDOM = 32;
    static final int ID_ROUND = 33;
    static final int ID_SIN = 34;
    static final int ID_SQRT = 35;
    static final int ID_TAN = 36;
    static final int ID_INIT_BOOLEAN = 37;
    static final int ID_INIT_STRING = 38;
    static final int ID_FROM_CHAR_CODE = 39;
    static final int ID_CHAR_AT = 40;
    static final int ID_CHAR_CODE_AT = 41;
    static final int ID_CONCAT = 42;
    static final int ID_INDEX_OF = 43;
    static final int ID_LAST_INDEX_OF = 44;
    static final int ID_LOCALE_COMPARE = 45;
    static final int ID_MATCH = 46;
    static final int ID_REPLACE = 47;
    static final int ID_SEARCH = 48;
    static final int ID_SLICE = 49;
    static final int ID_SPLIT = 50;
    static final int ID_SUBSTRING = 51;
    static final int ID_TO_LOWER_CASE = 52;
    static final int ID_TO_LOCALE_LOWER_CASE = 53;
    static final int ID_TO_UPPER_CASE = 54;
    static final int ID_TO_LOCALE_UPPER_CASE = 55;
    static final int ID_LENGTH = 56;
    static final int ID_LENGTH_SET = 57;
    static final int ID_INIT_NUMBER = 60;
    static final int ID_TO_FIXED = 61;
    static final int ID_TO_EXPONENTIAL = 62;
    static final int ID_TO_PRECISION = 63;
    static final int ID_PARSE = 64;
    static final int ID_UTC = 65;
    static final int ID_INIT_ARRAY = 66;
    static final int ID_INIT_ERROR = 67;
    static final int ID_INIT_FUNCTION = 68;
    static final int ID_INIT_DATE = 69;
    static final int ID_E = 70;
    static final int ID_E_SET = 71;
    static final int ID_LN10 = 72;
    static final int ID_LN10_SET = 73;
    static final int ID_LN2 = 74;
    static final int ID_LN2_SET = 75;
    static final int ID_LOG2E = 76;
    static final int ID_LOG2E_SET = 77;
    static final int ID_LOG10E = 78;
    static final int ID_LOG10E_SET = 79;
    static final int ID_PI = 80;
    static final int ID_PI_SET = 81;
    static final int ID_SQRT1_2 = 82;
    static final int ID_SQRT1_2_SET = 83;
    static final int ID_SQRT2 = 84;
    static final int ID_SQRT2_SET = 85;
    public static final int TYPE_UNDEFINED = 0;
    public static final int TYPE_NULL = 1;
    public static final int TYPE_OBJECT = 2;
    public static final int TYPE_BOOLEAN = 3;
    public static final int TYPE_NUMBER = 4;
    public static final int TYPE_STRING = 5;
    public static final int TYPE_FUNCTION = 6;
    static final String[] TYPE_NAMES = new String[]{"undefined", "object", "object", "boolean", "number", "string", "function"};
    private static final Object UNDEFINED_PLACEHOLDER = new Object();
    public static final JsObject OBJECT_PROTOTYPE = new JsObject(null).addVar("toString", new JsFunction(2, 0)).addVar("valueOf", new JsFunction(3, 0)).addVar("toLocaleString", new JsFunction(4, 0)).addVar("hasOwnProperty", new JsFunction(5, 1)).addVar("isPrototypeOf", new JsFunction(6, 1)).addVar("propertyIsEnumerable", new JsFunction(7, 1));
    public static final JsObject BOOLEAN_PROTOTYPE = new JsObject(OBJECT_PROTOTYPE);
    public static final JsObject NUMBER_PROTOTYPE = new JsObject(OBJECT_PROTOTYPE).addVar("toFixed", new JsFunction(61, 1)).addVar("toExponential", new JsFunction(62, 1)).addVar("toPrecision", new JsFunction(63, 1));
    public static final JsObject STRING_PROTOTYPE = new JsObject(OBJECT_PROTOTYPE).addVar("charAt", new JsFunction(40, 1)).addVar("charCodeAt", new JsFunction(41, 1)).addVar("concat", new JsFunction(42, 1)).addVar("indexOf", new JsFunction(43, 2)).addVar("lastIndexOf", new JsFunction(44, 2)).addVar("localeCompare", new JsFunction(45, 1)).addVar("replace", new JsFunction(47, 2)).addVar("search", new JsFunction(48, 1)).addVar("slice", new JsFunction(49, 2)).addVar("split", new JsFunction(50, 2)).addVar("substring", new JsFunction(51, 2)).addVar("toLowerCase", new JsFunction(52, 0)).addVar("toLocaleLowerCase", new JsFunction(53, 0)).addVar("toUpperCase", new JsFunction(54, 0)).addVar("toLocaleUpperCase", new JsFunction(55, 0)).addVar("length", new JsFunction(56, -1));
    public static final Object[] NO_PARAM = new Object[0];
    protected JsObject __proto__;
    private Hashtable natives = new Hashtable(10);
    private Hashtable data;
    protected JsObject scopeChain;
    Object value;

    public JsObject(JsObject __proto__) {
        this.__proto__ = __proto__;
    }

    public Object getRawInPrototypeChain(String key) {
        Object result;
        if (this.data != null && (result = this.data.get(key)) != null) {
            return result == UNDEFINED_PLACEHOLDER ? null : result;
        }
        if (this.__proto__ != null && (result = this.__proto__.getRawInPrototypeChain(key)) != null) {
            return result;
        }
        return null;
    }

    public Object getObject(String prop) {
        Object v = this.getRawInPrototypeChain(prop);
        if (v instanceof JsFunction) {
            JsFunction nat = (JsFunction)v;
            if (nat.getParameterCount() == -1) {
                JsArray stack = new JsArray();
                this.evalNative(nat.index, stack, 0, 0);
                return stack.getObject(0);
            }
        } else if (v == null && this.scopeChain != null) {
            v = this.scopeChain.getObject(prop);
        }
        return v;
    }

    public final double getNumber(String key) {
        return JsSystem.toNumber(this.getObject(key));
    }

    public final String getString(String key) {
        return JsSystem.toString(this.getObject(key));
    }

    public final int getInt(String key) {
        return (int)this.getNumber(key);
    }

    public void vmSetOperation(JsArray stack, int keyIndex, int valueIndex) {
        String key = stack.getString(keyIndex);
        this.setObject(key, stack.getObject(valueIndex));
    }

    public void vmGetOperation(JsArray stack, int keyIndex, int valueIndex) {
        String key = stack.getString(keyIndex);
        stack.setObject(valueIndex, this.getObject(key));
    }

    public JsObject addVar(String prop, Object v) {
        String key;
        if (this.data == null) {
            this.data = new Hashtable();
        }
        this.data.put(prop, v == null ? UNDEFINED_PLACEHOLDER : v);
        if (v instanceof JsFunction && ((JsFunction)v).index != -1 && (key = this.getNativeKey(((JsFunction)v).factoryTypeId, ((JsFunction)v).index)) != null) {
            if (this.natives.containsKey(key)) {
                System.out.println("Duplicate native function ID '" + ((JsFunction)v).index + "' detected for method '" + prop + "'.");
            } else {
                this.natives.put(key, prop);
            }
        }
        return this;
    }

    public JsObject addNative(String prop, int nativePropertyId, int parCount) {
        return this.addVar(prop, new JsFunction(nativePropertyId, parCount));
    }

    public String getFunctionName(int factoryTypeId, int index) {
        return this.getFunctionNameImpl(this.getNativeKey(factoryTypeId, index));
    }

    private String getFunctionNameImpl(String key) {
        String prop = (String)this.natives.get(key);
        if (prop == null && this.__proto__ != null) {
            prop = this.__proto__.getFunctionNameImpl(key);
        }
        return prop;
    }

    private String getNativeKey(int factoryTypeId, int index) {
        return factoryTypeId <= 0 ? "0:" + index : String.valueOf(factoryTypeId) + ":" + index;
    }

    public void setNumber(String key, double n) {
        this.setObject(key, new Double(n));
    }

    public void setObject(String key, Object v) {
        Object old = this.getRawInPrototypeChain(key);
        if (old instanceof JsFunction && ((JsFunction)old).getParameterCount() == -1) {
            JsFunction nat = (JsFunction)old;
            JsArray stack = new JsArray();
            stack.setObject(0, v);
            this.evalNative(nat.index + 1, stack, 0, 0);
            return;
        }
        if (old == null && this.scopeChain != null) {
            this.scopeChain.setObject(key, v);
        } else {
            if (this.data == null) {
                this.data = new Hashtable();
            }
            this.data.put(key, v == null ? UNDEFINED_PLACEHOLDER : v);
        }
    }

    public Enumeration keys() {
        if (this.data == null) {
            this.data = new Hashtable();
        }
        return this.data.keys();
    }

    public Enumeration elements() {
        if (this.data == null) {
            this.data = new Hashtable();
        }
        return this.data.elements();
    }

    public String toString() {
        return this.value == null ? "[object Object]" : this.value.toString();
    }

    public boolean delete(String key) {
        if (this.data == null) {
            return true;
        }
        Object old = this.data.get(key);
        boolean isFunc = old instanceof JsFunction;
        if (isFunc && ((JsFunction)old).getParameterCount() == -1) {
            return false;
        }
        this.data.remove(key);
        if (isFunc) {
            this.natives.remove(this.getNativeKey(((JsFunction)old).factoryTypeId, ((JsFunction)old).index));
        }
        return true;
    }

    public void clear() {
        if (this.data != null) {
            this.data.clear();
            this.data = null;
        }
    }

    public void evalNative(int index, JsArray stack, int sp, int parCount) {
        block2 : switch (index) {
            case -1: {
                break;
            }
            case 1: {
                Object obj = stack.getObject(sp + 2);
                if (this.isConstruction(stack, sp)) {
                    if (obj instanceof Boolean || obj instanceof Double || obj instanceof String) {
                        this.value = obj;
                        break;
                    }
                    if (!(obj instanceof JsObject)) break;
                    stack.setObject(sp - 1, obj);
                    break;
                }
                if (obj == null || obj == JsSystem.JS_NULL) {
                    stack.setObject(sp, (Object)new JsObject(OBJECT_PROTOTYPE));
                    break;
                }
                stack.setObject(sp, (Object)JsSystem.toJsObject(obj));
                break;
            }
            case 2: 
            case 4: {
                stack.setObject(sp, (Object)JsSystem.toString(stack.getObject(sp)));
                break;
            }
            case 5: {
                stack.setBoolean(sp, this.data != null && this.data.get(stack.getString(sp + 2)) != null);
                break;
            }
            case 6: {
                Object obj = stack.getObject(sp + 2);
                stack.setBoolean(sp, false);
                while (obj instanceof JsObject) {
                    if (obj != this) continue;
                    stack.setBoolean(sp, true);
                    break block2;
                }
                break;
            }
            case 7: {
                Object obj = this.getRawInPrototypeChain(stack.getString(sp + 2));
                stack.setBoolean(sp, obj != null && !(obj instanceof JsFunction));
                break;
            }
            case 3: {
                stack.setObject(sp, this.value == null ? this : this.value);
                break;
            }
            case 60: {
                if (this.isConstruction(stack, sp)) {
                    this.value = new Double(stack.getNumber(sp + 2));
                    break;
                }
                stack.setNumber(sp, stack.getNumber(sp + 2));
                break;
            }
            case 37: {
                if (this.isConstruction(stack, sp)) {
                    this.value = stack.getBoolean(sp + 2) ? Boolean.TRUE : Boolean.FALSE;
                    break;
                }
                stack.setObject(sp, (Object)(stack.getBoolean(sp + 2) ? Boolean.TRUE : Boolean.FALSE));
                break;
            }
            case 38: {
                if (this.isConstruction(stack, sp)) {
                    this.value = stack.getString(sp + 2);
                    break;
                }
                stack.setObject(sp, (Object)(parCount == 0 ? "" : stack.getString(sp + 2)));
                break;
            }
            case 66: {
                JsArray array;
                JsArray jsArray = array = this.isConstruction(stack, sp) ? (JsArray)this : new JsArray();
                if (parCount == 1 && stack.isNumber(sp + 2)) {
                    array.setSize(stack.getInt(sp + 2));
                } else {
                    int i = 0;
                    while (i < parCount) {
                        stack.copy(sp + i + 2, array, i);
                        ++i;
                    }
                }
                stack.setObject(sp, (Object)array);
                break;
            }
            case 67: {
                if (this.isConstruction(stack, sp)) {
                    this.setObject("message", stack.getString(sp + 2));
                    break;
                }
                stack.setObject(sp, (Object)new JsError(stack.getJsObject(sp), stack.getString(sp + 2)));
                break;
            }
            case 68: {
                boolean construction = this.isConstruction(stack, sp);
                StringBuffer buf = new StringBuffer("(function(");
                int i = 0;
                while (i < parCount - 1) {
                    if (i != 0) {
                        buf.append(',');
                    }
                    buf.append(stack.getString(sp + 2 + i));
                    ++i;
                }
                buf.append("){");
                if (parCount != 0) {
                    buf.append(stack.getString(sp + 2 + parCount - 1));
                }
                buf.append("});");
                System.out.println("eval: " + buf);
                JsObject global = (JsObject)stack.getObject(0);
                JsFunction eval = (JsFunction)global.getObject("eval");
                stack.setObject(sp, (Object)global);
                stack.setObject(sp + 1, (Object)eval);
                stack.setObject(sp + 2, (Object)buf.toString());
                eval.eval(stack, sp, 1);
                if (!construction) break;
                stack.copy(sp, stack, sp - 1);
                break;
            }
            case 69: {
                if (this.isConstruction(stack, sp)) {
                    JsDate d = (JsDate)this;
                    if (parCount == 1) {
                        d.time.setTime(new Date((long)stack.getNumber(sp + 2)));
                        break;
                    }
                    if (parCount <= 1) break;
                    d.time.setTime(new Date(0L));
                    int year = stack.getInt(sp + 2);
                    if (year >= 0 && year <= 99) {
                        year += 1900;
                    }
                    d.setDate(false, year, stack.getNumber(sp + 3), stack.getNumber(sp + 4));
                    d.setTime(false, stack.getNumber(sp + 5), stack.getNumber(sp + 6), stack.getNumber(sp + 7), stack.getNumber(sp + 8));
                    break;
                }
                stack.setObject(sp, (Object)new JsDate(JsDate.DATE_PROTOTYPE).toString(true, true, true));
                break;
            }
            case 18: {
                System.out.println(stack.getString(sp + 2));
                break;
            }
            case 10: {
                String s = stack.getString(sp + 2).trim().toLowerCase();
                try {
                    if (stack.isNull(sp + 3)) {
                        stack.setInt(sp, s.startsWith("0x") ? Integer.parseInt(s.substring(2), 16) : Integer.parseInt(s));
                        break;
                    }
                    stack.setInt(sp, Integer.parseInt(s, stack.getInt(sp + 3)));
                }
                catch (NumberFormatException e) {
                    stack.setInt(sp, 0);
                }
                break;
            }
            case 11: {
                try {
                    stack.setNumber(sp, Double.parseDouble(stack.getString(sp + 2)));
                }
                catch (NumberFormatException e) {
                    stack.setNumber(sp, Double.NaN);
                }
                break;
            }
            case 12: {
                stack.setBoolean(sp, Double.isNaN(stack.getNumber(sp + 2)));
                break;
            }
            case 13: {
                double d = stack.getNumber(sp + 2);
                stack.setBoolean(sp, !Double.isInfinite(d) && !Double.isNaN(d));
                break;
            }
            case 14: {
                Object obj = stack.getObject(sp + 2);
                if (obj instanceof byte[]) {
                    stack.setObject(sp, (Object)JsSystem.decodeURI((byte[])obj));
                    break;
                }
                stack.setObject(sp, (Object)JsSystem.decodeURI(obj.toString()));
                break;
            }
            case 16: {
                Object obj = stack.getObject(sp + 2);
                if (obj instanceof byte[]) {
                    stack.setObject(sp, (Object)JsSystem.encodeURI((byte[])obj));
                    break;
                }
                stack.setObject(sp, (Object)JsSystem.encodeURI(obj.toString()));
                break;
            }
            case 15: 
            case 17: {
                throw new RuntimeException("NYI");
            }
            case 19: {
                stack.setNumber(sp, Math.abs(stack.getNumber(sp + 2)));
                break;
            }
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                throw new RuntimeException("NYI");
            }
            case 24: {
                stack.setNumber(sp, Math.ceil(stack.getNumber(sp + 2)));
                break;
            }
            case 25: {
                stack.setNumber(sp, Math.cos(stack.getNumber(sp + 2)));
                break;
            }
            case 26: {
                stack.setNumber(sp, JsSystem.exp(stack.getNumber(sp + 2)));
                break;
            }
            case 27: {
                stack.setNumber(sp, Math.floor(stack.getNumber(sp + 2)));
                break;
            }
            case 28: {
                stack.setNumber(sp, JsSystem.ln(stack.getNumber(sp + 2)));
                break;
            }
            case 29: {
                double d = Double.NEGATIVE_INFINITY;
                int i = 0;
                while (i < parCount) {
                    d = Math.max(d, stack.getNumber(sp + 2 + i));
                    ++i;
                }
                stack.setNumber(sp, d);
                break;
            }
            case 30: {
                double d = Double.POSITIVE_INFINITY;
                int i = 0;
                while (i < parCount) {
                    d = Math.min(d, stack.getNumber(sp + 2 + i));
                    ++i;
                }
                stack.setNumber(sp, d);
                break;
            }
            case 31: {
                stack.setNumber(sp, JsSystem.pow(stack.getNumber(sp + 2), stack.getNumber(sp + 3)));
                break;
            }
            case 32: {
                stack.setNumber(sp, JsSystem.random.nextDouble());
                break;
            }
            case 33: {
                stack.setNumber(sp, Math.floor(stack.getNumber(sp + 2) + 0.5));
                break;
            }
            case 34: {
                stack.setNumber(sp, Math.sin(stack.getNumber(sp + 2)));
                break;
            }
            case 35: {
                stack.setNumber(sp, Math.sqrt(stack.getNumber(sp + 2)));
                break;
            }
            case 36: {
                stack.setNumber(sp, Math.tan(stack.getNumber(sp + 2)));
                break;
            }
            case 39: {
                char[] chars = new char[parCount];
                int i = 0;
                while (i < parCount) {
                    chars[i] = (char)stack.getInt(sp + 2 + i);
                    ++i;
                }
                stack.setObject(sp, (Object)new String(chars));
                break;
            }
            case 40: {
                String s = stack.getString(sp);
                int i = stack.getInt(sp + 2);
                stack.setObject(sp, (Object)(i < 0 || i >= s.length() ? "" : s.substring(i, i + 1)));
                break;
            }
            case 41: {
                String s = stack.getString(sp);
                int i = stack.getInt(sp + 2);
                stack.setNumber(sp, i < 0 || i >= s.length() ? Double.NaN : (double)s.charAt(i));
                break;
            }
            case 42: {
                StringBuffer buf = new StringBuffer(stack.getString(sp));
                int i = 0;
                while (i < parCount) {
                    buf.append(stack.getString(sp + i + 2));
                    ++i;
                }
                stack.setObject(sp, (Object)buf.toString());
                break;
            }
            case 43: {
                stack.setNumber(sp, (double)stack.getString(sp).indexOf(stack.getString(sp + 2), stack.getInt(sp + 3)));
                break;
            }
            case 44: {
                int found;
                String s = stack.getString(sp);
                String find = stack.getString(sp + 2);
                double d = stack.getNumber(sp + 3);
                int max = Double.isNaN(d) ? s.length() : (int)d;
                int best = -1;
                while ((found = s.indexOf(find, best + 1)) != -1 && found <= max) {
                    best = found;
                }
                stack.setNumber(sp, (double)best);
                break;
            }
            case 45: {
                stack.setNumber(sp, (double)stack.getString(sp).compareTo(stack.getString(sp + 2)));
                break;
            }
            case 47: {
                String s = stack.getString(sp);
                String find = stack.getString(sp + 2);
                String replace = stack.getString(sp + 3);
                if (find.equals("")) break;
                StringBuffer sb = new StringBuffer(s);
                int length = find.length();
                while ((index = sb.toString().indexOf(find)) >= 0) {
                    sb.delete(index, index + length);
                    sb.insert(index, replace);
                }
                stack.setObject(sp, (Object)sb.toString());
                sb = null;
                break;
            }
            case 46: 
            case 48: {
                throw new RuntimeException("Regexp NYI");
            }
            case 49: {
                int end;
                String s = stack.getString(sp);
                int len = s.length();
                int start = stack.getInt(sp + 2);
                int n = end = stack.isNull(sp + 3) ? len : stack.getInt(sp + 3);
                if (start < 0) {
                    start = Math.max(len + start, 0);
                }
                if (end < 0) {
                    end = Math.max(len + start, 0);
                }
                if (start > len) {
                    start = len;
                }
                if (end > len) {
                    end = len;
                }
                if (end < start) {
                    end = start;
                }
                stack.setObject(sp, (Object)s.substring(start, end));
                break;
            }
            case 50: {
                String s = stack.getString(sp);
                String sep = stack.getString(sp + 2);
                double limit = stack.getNumber(sp + 3);
                if (Double.isNaN(limit) || limit < 1.0) {
                    limit = Double.MAX_VALUE;
                }
                JsArray a = new JsArray();
                if (sep.length() == 0) {
                    if ((double)s.length() < limit) {
                        limit = s.length();
                    }
                    int i = 0;
                    while ((double)i < limit) {
                        a.setObject(i, (Object)s.substring(i, i + 1));
                        ++i;
                    }
                } else {
                    int cut0 = 0;
                    while (cut0 < s.length() && (double)a.size() < limit) {
                        int cut = s.indexOf(sep, cut0);
                        if (cut == -1) {
                            cut = s.length();
                        }
                        a.setObject(a.size(), (Object)s.substring(cut0, cut));
                        cut0 = cut + sep.length();
                    }
                }
                stack.setObject(sp, (Object)a);
                break;
            }
            case 51: {
                int end;
                String s = stack.getString(sp);
                int len = s.length();
                int start = stack.getInt(sp + 2);
                int n = end = stack.isNull(sp + 3) ? len : stack.getInt(sp + 3);
                if (start > end) {
                    int tmp = end;
                    end = start;
                    start = tmp;
                }
                start = Math.min(Math.max(0, start), len);
                end = Math.min(Math.max(0, end), len);
                stack.setObject(sp, (Object)s.substring(start, end));
                break;
            }
            case 52: 
            case 53: {
                stack.setObject(sp, (Object)stack.getString(sp + 2).toLowerCase());
                break;
            }
            case 54: 
            case 55: {
                stack.setObject(sp, (Object)stack.getString(sp + 2).toUpperCase());
                break;
            }
            case 56: {
                stack.setInt(sp, this.toString().length());
                break;
            }
            case 57: {
                break;
            }
            case 61: 
            case 62: 
            case 63: {
                stack.setObject(sp, (Object)JsSystem.formatNumber(index, stack.getNumber(sp + 2), stack.getNumber(sp + 3)));
                break;
            }
            case 65: {
                JsDate date = new JsDate(JsDate.DATE_PROTOTYPE);
                date.time.setTime(new Date(0L));
                int year = stack.getInt(sp + 2);
                if (year >= 0 && year <= 99) {
                    year += 1900;
                }
                date.setDate(true, year, stack.getNumber(sp + 3), stack.getNumber(sp + 4));
                date.setTime(true, stack.getNumber(sp + 5), stack.getNumber(sp + 6), stack.getNumber(sp + 7), stack.getNumber(sp + 8));
                stack.setNumber(sp, (double)date.time.getTime().getTime());
                break;
            }
            case 64: {
                double[] vals = new double[]{Double.NaN, Double.NaN, Double.NaN, Double.NaN, Double.NaN, Double.NaN, Double.NaN};
                String s = stack.getString(sp + 2);
                int curr = -1;
                int pos = 0;
                int i = 0;
                while (i < s.length()) {
                    char c = s.charAt(i);
                    if (c >= '0' && c <= '9') {
                        curr = curr == -1 ? c - 48 : curr * 10 + (c - 48);
                    } else if (curr != -1) {
                        if (pos < vals.length) {
                            vals[pos++] = curr;
                        }
                        curr = -1;
                    }
                    ++i;
                }
                if (curr != -1 && pos < vals.length) {
                    vals[pos++] = curr;
                }
                boolean utc = s.endsWith("GMT") || s.endsWith("UTC");
                JsDate date = new JsDate(JsDate.DATE_PROTOTYPE);
                date.time.setTime(new Date(0L));
                date.setDate(utc, vals[0], vals[1], vals[2]);
                date.setTime(utc, vals[3], vals[4], vals[5], vals[6]);
                stack.setNumber(sp, (double)date.time.getTime().getTime());
                break;
            }
            case 70: {
                stack.setNumber(sp, Math.E);
                break;
            }
            case 72: {
                stack.setNumber(sp, 2.302585092994046);
                break;
            }
            case 74: {
                stack.setNumber(sp, 0.6931471805599453);
                break;
            }
            case 76: {
                stack.setNumber(sp, 1.4426950408889634);
                break;
            }
            case 78: {
                stack.setNumber(sp, 0.4342944819032518);
                break;
            }
            case 80: {
                stack.setNumber(sp, Math.PI);
                break;
            }
            case 82: {
                stack.setNumber(sp, Math.sqrt(0.5));
                break;
            }
            case 84: {
                stack.setNumber(sp, Math.sqrt(2.0));
                break;
            }
            case 71: 
            case 73: 
            case 75: 
            case 77: 
            case 79: 
            case 81: 
            case 83: 
            case 85: {
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown native id: " + index + " this: " + this);
            }
        }
    }

    protected boolean isConstruction(JsArray stack, int sp) {
        return sp > 0 && stack.getObject(sp - 1) == stack.getObject(sp);
    }
}

