/*
 * Decompiled with CFR 0.152.
 */
package net.comcraft.src;

import java.util.Random;
import javax.microedition.m3g.IndexBuffer;
import javax.microedition.m3g.VertexBuffer;
import net.comcraft.src.AxisAlignedBB;
import net.comcraft.src.Block;
import net.comcraft.src.EffectExplosion;
import net.comcraft.src.EntityPlayer;
import net.comcraft.src.InvItemStack;
import net.comcraft.src.ModelPresent;
import net.comcraft.src.World;

public class BlockPresent
extends Block {
    private Random rand;
    private boolean boomable;

    public BlockPresent(int id, int index, boolean boomable) {
        super(id, index);
        this.boomable = boomable;
        this.rand = new Random();
    }

    public boolean canBePieced() {
        return false;
    }

    public boolean canBePiecedVertically() {
        return false;
    }

    public boolean shouldSideBeRendered(World world, int x, int y, int z, int side) {
        return true;
    }

    public VertexBuffer[][][][] getBlockVertexBuffer(World world, int x, int y, int z) {
        return ModelPresent.vertexBuffer;
    }

    public IndexBuffer getBlockIndexBuffer() {
        return ModelPresent.indexBuffer;
    }

    public boolean isNormal() {
        return false;
    }

    public AxisAlignedBB getCollisionBoundingBoxFromPool(World world, int x, int y, int z) {
        return AxisAlignedBB.getBoundingBox((float)x + 0.2f, (float)y + 0.0f, (float)z + 0.2f, (float)x + 0.8f, (float)y + 0.5f, (float)z + 0.8f);
    }

    private void addBoomEfects(World world, int x, int y, int z) {
        int particles = this.rand.nextInt(10) + 30;
        int n = 0;
        while (n < particles) {
            float xD = this.rand.nextFloat() * 7.0f - 3.5f + (float)x;
            float yD = this.rand.nextFloat() * 5.0f - 2.5f + (float)y;
            float zD = this.rand.nextFloat() * 7.0f - 3.5f + (float)z;
            world.cc.render.renderEffects.addEffect(new EffectExplosion(world.cc, "misc/explosion.png", xD * 10.0f, yD * 10.0f, zD * 10.0f));
            ++n;
        }
    }

    private void presentBoom(World world, int x, int y, int z) {
        world.cc.vibrate(200);
        world.setBlockID(x, y, z, 0);
        this.addBoomEfects(world, x, y, z);
    }

    public boolean blockActivated(World world, int x, int y, int z, EntityPlayer entityplayer, InvItemStack itemStack) {
        if (!this.boomable) {
            return false;
        }
        this.presentBoom(world, x, y, z);
        return true;
    }
}

