/*
 * Decompiled with CFR 0.152.
 */
package net.comcraft.src;

import javax.microedition.m3g.IndexBuffer;
import javax.microedition.m3g.Transform;
import javax.microedition.m3g.VertexBuffer;
import net.comcraft.src.AxisAlignedBB;
import net.comcraft.src.Block;
import net.comcraft.src.EntityPlayer;
import net.comcraft.src.InvItemStack;
import net.comcraft.src.ModelTorch;
import net.comcraft.src.World;

public class BlockTorch
extends Block {
    public BlockTorch(int id, int index) {
        super(id, index);
    }

    public boolean collidesWithPlayer() {
        return false;
    }

    public boolean doesBlockDestroyGrass() {
        return false;
    }

    public boolean canBePieced() {
        return false;
    }

    public boolean canBePiecedVertically() {
        return false;
    }

    public boolean shouldSideBeRendered(World world, int x, int y, int z, int side) {
        return true;
    }

    public Transform getBlockTransform(World world, int x, int y, int z, Transform transform, int s) {
        if (world == null) {
            return transform;
        }
        Transform blockTransform = new Transform();
        blockTransform.set(transform);
        int side = world.getBlockMetadata(x, y, z);
        if (side < 4) {
            if (side == 0) {
                blockTransform.postTranslate(0.0f, 5.0f, -4.0f);
                blockTransform.postRotate(30.0f, 1.0f, 0.0f, 0.0f);
            } else if (side == 1) {
                blockTransform.postTranslate(0.0f, 0.0f, 6.0f);
                blockTransform.postRotate(-30.0f, 1.0f, 0.0f, 0.0f);
            } else if (side == 2) {
                blockTransform.postTranslate(-4.0f, 5.0f, 0.0f);
                blockTransform.postRotate(-30.0f, 0.0f, 0.0f, 1.0f);
            } else if (side == 3) {
                blockTransform.postTranslate(6.0f, 0.0f, 0.0f);
                blockTransform.postRotate(30.0f, 0.0f, 0.0f, 1.0f);
            }
        }
        return blockTransform;
    }

    public void onBlockPlaced(World world, int x, int y, int z, int side) {
        world.setBlockMetadata(x, y, z, side);
    }

    public boolean canPlaceBlockOnSide(World world, int x, int y, int z, int side) {
        return side != 5;
    }

    public VertexBuffer[] getBlockVertexBufferSided(World world, int x, int y, int z) {
        return ModelTorch.vertexBuffer;
    }

    public IndexBuffer getBlockIndexBuffer() {
        return ModelTorch.indexBuffer;
    }

    public int getRenderType() {
        return 5;
    }

    public AxisAlignedBB getCollisionBoundingBoxFromPool(World world, int x, int y, int z) {
        return AxisAlignedBB.getBoundingBox(x, y, z, (float)x + 1.0f, (float)y + 1.0f, (float)z + 1.0f);
    }

    public boolean blockActivated(World world, int x, int y, int z, EntityPlayer entityplayer, InvItemStack itemStack) {
        return true;
    }

    public boolean isNormal() {
        return false;
    }

    public void onNeighborBlockChange(World world, int x, int y, int z, int blockID) {
        int side = world.getBlockMetadata(x, y, z);
        int tX = x--;
        int tY = y--;
        int tZ = z--;
        if (side != 0) {
            if (side == 1) {
                ++z;
            } else if (side != 2) {
                if (side == 3) {
                    ++x;
                } else if (side != 4 && side == 5) {
                    --y;
                }
            }
        }
        if (world.isAirBlock(x, y, z)) {
            world.setBlockID(tX, tY, tZ, 0);
        }
    }
}

