/*
 * Decompiled with CFR 0.152.
 */
package net.comcraft.src;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import net.comcraft.client.Comcraft;
import net.comcraft.src.Chunk;
import net.comcraft.src.ChunkEmpty;
import net.comcraft.src.ChunkLoader;
import net.comcraft.src.ComcraftException;
import net.comcraft.src.LoadingScreen;
import net.comcraft.src.ServerGame;
import net.comcraft.src.World;

public class ChunkManager
implements Runnable {
    public final Comcraft cc;
    public final boolean isServerGame;
    private Hashtable chunksMap;
    private ChunkLoader chunkLoader;
    private ChunkEmpty emptyChunk;
    private Vector chunksQueue;
    private boolean isAlive;
    private long lastUnusedChunksCheck;
    private Chunk[][] chunksTable;
    private World world;

    public ChunkManager(Comcraft cc, ChunkLoader chunkLoader, World world) {
        this.cc = cc;
        this.isServerGame = chunkLoader instanceof ServerGame;
        this.world = world;
        this.chunkLoader = chunkLoader;
        this.chunksMap = new Hashtable(1024);
        this.emptyChunk = new ChunkEmpty();
        this.chunksQueue = new Vector(256);
        this.chunksTable = new Chunk[world.worldSize][world.worldSize];
        this.startThread();
    }

    public void releaseUnusedChunks() {
        if (this.cc.currentTime - this.lastUnusedChunksCheck < 3500L) {
            return;
        }
        int size = this.cc.settings.renderDistance * 2 + 3;
        int startX = ((int)this.cc.player.xPos >> 2) - this.cc.settings.renderDistance - 1;
        int startZ = ((int)this.cc.player.zPos >> 2) - this.cc.settings.renderDistance - 1;
        Enumeration enumeration = this.chunksMap.keys();
        while (enumeration.hasMoreElements()) {
            Chunk chunk;
            Integer id = (Integer)enumeration.nextElement();
            int x = ChunkManager.getDecodedChunkX(id, this.world.worldSize);
            int z = ChunkManager.getDecodedChunkZ(id, this.world.worldSize);
            if (x >= startX && x <= startX + size && z >= startZ && z <= startZ + size || (chunk = (Chunk)this.chunksMap.get(id)).isEdited()) continue;
            this.chunksMap.remove(id);
        }
        this.lastUnusedChunksCheck = this.cc.currentTime;
    }

    private void startThread() {
        this.isAlive = true;
        Thread thread = new Thread(this);
        thread.start();
    }

    public Chunk getChunk(int x, int z) {
        if (x < 0 || x >= this.world.worldSize || z < 0 || z >= this.world.worldSize) {
            return this.emptyChunk;
        }
        Chunk chunk = this.chunksTable[x][z];
        if (chunk == null) {
            chunk = (Chunk)this.chunksMap.get(ChunkManager.getChunkID(x, z, this.world.worldSize));
            if (chunk == null) {
                chunk = this.loadChunk(x, z);
            }
            if (!chunk.isEmptyChunk()) {
                this.chunksTable[x][z] = chunk;
            }
        }
        return chunk;
    }

    public Chunk loadChunk(int x, int z) {
        if (x < 0 || x >= this.world.worldSize || z < 0 || z >= this.world.worldSize) {
            return this.emptyChunk;
        }
        Integer id = ChunkManager.getChunkID(x, z, this.world.worldSize);
        if (!this.chunksQueue.contains(id)) {
            this.chunksQueue.addElement(id);
        }
        return this.emptyChunk;
    }

    public static Integer getChunkID(int x, int z, int worldSize) {
        return new Integer(x + z * worldSize);
    }

    public static int getDecodedChunkX(Integer chunkId, int worldSize) {
        int id = chunkId;
        return id % worldSize;
    }

    public static int getDecodedChunkZ(Integer chunkId, int worldSize) {
        int id = chunkId;
        return (id - ChunkManager.getDecodedChunkX(chunkId, worldSize)) / worldSize;
    }

    public void saveAllChunks(LoadingScreen loadingScreen) {
        if (!this.chunksQueue.isEmpty()) {
            this.chunksQueue.removeAllElements();
        }
        this.chunkLoader.saveChunks(this.chunksMap, loadingScreen);
    }

    public void onChunkProviderEnd() {
        this.chunkLoader.onChunkLoaderEnd();
        this.isAlive = false;
    }

    public int getLoadedChunksNum() {
        return this.chunksMap.size();
    }

    public int getChunksQueueNum() {
        return this.chunksQueue.size();
    }

    private Integer getTheClosestChunk() {
        Integer closest = (Integer)this.chunksQueue.firstElement();
        int n = 1;
        while (n < this.chunksQueue.size()) {
            Integer c = (Integer)this.chunksQueue.elementAt(n);
            if (c < closest) {
                closest = c;
            }
            ++n;
        }
        return closest;
    }

    public void run() {
        while (this.isAlive) {
            if (!this.chunksQueue.isEmpty()) {
                try {
                    Integer integer = this.getTheClosestChunk();
                    int x = ChunkManager.getDecodedChunkX(integer, this.world.worldSize);
                    int z = ChunkManager.getDecodedChunkZ(integer, this.world.worldSize);
                    Chunk chunk = this.chunkLoader.loadChunk(x, z);
                    this.chunksMap.put(ChunkManager.getChunkID(x, z, this.world.worldSize), chunk);
                    this.chunksQueue.removeElement(integer);
                    continue;
                }
                catch (OutOfMemoryError error) {
                    if (this.cc.settings.ignoreOutOfMemory) continue;
                    throw error;
                }
            }
            if (this.isServerGame) continue;
            try {
                Thread.sleep(750L);
            }
            catch (InterruptedException ex) {
                throw new ComcraftException(ex);
            }
        }
    }
}

