/*
 * Decompiled with CFR 0.152.
 */
package net.comcraft.src;

import javax.microedition.m3g.Transform;
import javax.microedition.m3g.VertexBuffer;
import net.comcraft.src.Block;
import net.comcraft.src.World;

public class ChunkPiece {
    private Transform transform;
    private int xSize;
    private int ySize;
    private int zSize;
    private long lastTick;
    private boolean[] doneSides;
    private Block block;

    public ChunkPiece(int xPos, int yPos, int zPos, int xSize, int ySize, int zSize, Block block) {
        this.xSize = xSize;
        this.ySize = ySize;
        this.zSize = zSize;
        this.block = block;
        this.transform = new Transform();
        this.transform.postTranslate((float)(xPos * 10), (float)(yPos * 10), (float)(zPos * 10));
    }

    public int getSizeX() {
        return this.xSize;
    }

    public int getSizeY() {
        return this.ySize;
    }

    public int getSizeZ() {
        return this.zSize;
    }

    public VertexBuffer getVertexBuffer(World world, int side) {
        return this.block.getBlockVertexBufferPieced(world, 0, 0, 0)[this.xSize][this.ySize][this.zSize][side];
    }

    public Transform getTransform() {
        return this.transform;
    }

    public boolean needsRender(long currentTick, int side) {
        if (currentTick > this.lastTick) {
            this.doneSides = new boolean[6];
            this.doneSides[side] = true;
            this.lastTick = currentTick;
            return true;
        }
        if (!this.doneSides[side]) {
            this.doneSides[side] = true;
            return true;
        }
        return false;
    }
}

