/*
 * Decompiled with CFR 0.152.
 */
package net.comcraft.src;

import net.comcraft.src.AABox;
import net.comcraft.src.MathHelper;
import net.comcraft.src.Plane;
import net.comcraft.src.Vec3D;

public class Frustum {
    private static final short TOP = 0;
    private static final short BOTTOM = 1;
    private static final short LEFT = 2;
    private static final short RIGHT = 3;
    private static final short NEARP = 4;
    private static final short FARP = 5;
    public static final short OUTSIDE = 0;
    public static final short INTERSECT = 1;
    public static final short INSIDE = 2;
    private static final float HALF_ANG2RAD = (float)Math.PI / 360;
    private Plane[] pl = new Plane[6];
    private Vec3D ntl;
    private Vec3D ntr;
    private Vec3D nbl;
    private Vec3D nbr;
    private Vec3D ftl;
    private Vec3D fbl;
    private Vec3D fbr;
    private Vec3D X;
    private Vec3D Y;
    private Vec3D Z;
    private Vec3D camPos;
    private float nearD;
    private float farD;
    private float ratio;
    private float angle;
    private float sphereFactorX;
    private float sphereFactorY;
    private double tang;
    private double nw;
    private double nh;
    private double fw;
    private double fh;

    public Frustum() {
        int x = 0;
        while (x < 6) {
            this.pl[x] = new Plane();
            ++x;
        }
    }

    public void setCamInternals(float angle, float ratio, float nearD, float farD) {
        this.ratio = ratio;
        this.angle = angle * ((float)Math.PI / 360);
        this.nearD = nearD;
        this.farD = farD;
        this.tang = Math.tan(this.angle);
        this.sphereFactorY = (float)(1.0 / Math.cos(this.angle));
        float anglex = (float)MathHelper.atan(this.tang * (double)ratio);
        this.sphereFactorX = (float)(1.0 / Math.cos(anglex));
        this.nh = (double)nearD * this.tang;
        this.nw = this.nh * (double)ratio;
        this.fh = (double)farD * this.tang;
        this.fw = this.fh * (double)ratio;
    }

    public void setCamDef(Vec3D p, Vec3D l, Vec3D u) {
        this.camPos = p;
        this.Z = p.subtractVector(l);
        this.Z.normalize();
        this.X = u.crossProduct(this.Z);
        this.X.normalize();
        this.Y = this.Z.crossProduct(this.X);
        Vec3D nc = p.subtractVector(this.Z.crossProduct(this.nearD));
        Vec3D fc = p.subtractVector(this.Z.crossProduct(this.farD));
        this.ntl = nc.addVector(this.Y.crossProduct((float)this.nh)).subtractVector(this.X.crossProduct((float)this.nw));
        this.ntr = nc.addVector(this.Y.crossProduct((float)this.nh)).addVector(this.X.crossProduct((float)this.nw));
        this.nbl = nc.subtractVector(this.Y.crossProduct((float)this.nh)).subtractVector(this.X.crossProduct((float)this.nw));
        this.nbr = nc.subtractVector(this.Y.crossProduct((float)this.nh)).addVector(this.X.crossProduct((float)this.nw));
        this.ftl = fc.addVector(this.Y.crossProduct((float)this.fh)).subtractVector(this.X.crossProduct((float)this.fw));
        this.fbr = fc.subtractVector(this.Y.crossProduct((float)this.fh)).addVector(this.X.crossProduct((float)this.fw));
        fc.addVector(this.Y.crossProduct((float)this.fh)).addVector(this.X.crossProduct((float)this.fw));
        this.fbl = fc.subtractVector(this.Y.crossProduct((float)this.fh)).subtractVector(this.X.crossProduct((float)this.fw));
        this.pl[0].set3Points(this.ntr, this.ntl, this.ftl);
        this.pl[1].set3Points(this.nbl, this.nbr, this.fbr);
        this.pl[2].set3Points(this.ntl, this.nbl, this.fbl);
        this.pl[3].set3Points(this.nbr, this.ntr, this.fbr);
        this.pl[4].setNormalAndPoint(this.Z.subtractVector(), nc);
        this.pl[5].setNormalAndPoint(this.Z, fc);
        Vec3D aux = nc.addVector(this.Y.crossProduct((float)this.nh)).subtractVector(p);
        Vec3D normal = aux.crossProduct(this.X);
        this.pl[0].setNormalAndPoint(normal, nc.addVector(this.Y.crossProduct((float)this.nh)));
        aux = nc.subtractVector(this.Y.crossProduct((float)this.nh)).subtractVector(p);
        normal = this.X.crossProduct(aux);
        this.pl[1].setNormalAndPoint(normal, nc.subtractVector(this.Y.crossProduct((float)this.nh)));
        aux = nc.subtractVector(this.X.crossProduct((float)this.nw)).subtractVector(p);
        normal = aux.crossProduct(this.Y);
        this.pl[2].setNormalAndPoint(normal, nc.subtractVector(this.X.crossProduct((float)this.nw)));
        aux = nc.addVector(this.X.crossProduct((float)this.nw)).subtractVector(p);
        normal = this.Y.crossProduct(aux);
        this.pl[3].setNormalAndPoint(normal, nc.addVector(this.X.crossProduct((float)this.nw)));
    }

    public short pointInFrustum(Vec3D p) {
        float aux;
        Vec3D v = p.subtractVector(this.camPos);
        float pcz = v.innerProduct(this.Z.subtractVector());
        if (pcz > this.farD || pcz < this.nearD) {
            return 0;
        }
        float pcy = v.innerProduct(this.Y);
        if (pcy > (aux = pcz * (float)this.tang) || pcy < -aux) {
            return 0;
        }
        float pcx = v.innerProduct(this.X);
        if (pcx > (aux *= this.ratio) || pcx < -aux) {
            return 0;
        }
        return 2;
    }

    public int sphereInFrustum(Vec3D p, float radius) {
        float d2;
        float zz2;
        float d1;
        float zz1;
        int result = 2;
        Vec3D v = p.subtractVector(this.camPos);
        float az = v.innerProduct(this.Z.subtractVector());
        if (az > this.farD + radius || az < this.nearD - radius) {
            return 0;
        }
        float ax = v.innerProduct(this.X);
        if (ax > (zz1 = az * (float)this.tang * this.ratio) + (d1 = this.sphereFactorX * radius) || ax < -zz1 - d1) {
            return 0;
        }
        float ay = v.innerProduct(this.Y);
        if (ay > (zz2 = az * (float)this.tang) + (d2 = this.sphereFactorY * radius) || ay < -zz2 - d2) {
            return 0;
        }
        if (az > this.farD - radius || az < this.nearD + radius) {
            result = 1;
        }
        if (ay > zz2 - d2 || ay < -zz2 + d2) {
            result = 1;
        }
        if (ax > zz1 - d1 || ax < -zz1 + d1) {
            result = 1;
        }
        return result;
    }

    public int boxInFrustum(AABox b) {
        int result = 2;
        int i = 0;
        while (i < 6) {
            if (this.pl[i].distance(b.getVertexP(this.pl[i].normal)) < 0.0f) {
                return 0;
            }
            if (this.pl[i].distance(b.getVertexN(this.pl[i].normal)) < 0.0f) {
                result = 1;
            }
            ++i;
        }
        return result;
    }

    public int chunkInFrustum(Vec3D vec0, int x, int y, int z) {
        int number = 10;
        Vec3D[] corners = new Vec3D[(number + 1) * 4];
        int i = 0;
        while (i <= number) {
            corners[i * 4] = new Vec3D(vec0.x + (float)x, vec0.y + (float)y * ((float)i / (float)number), vec0.z);
            corners[i * 4 + 1] = new Vec3D(vec0.x, vec0.y + (float)y * ((float)i / (float)number), vec0.z + (float)z);
            corners[i * 4 + 2] = new Vec3D(vec0.x, vec0.y + (float)y * ((float)i / (float)number), vec0.z);
            corners[i * 4 + 3] = new Vec3D(vec0.x + (float)x, vec0.y + (float)y * ((float)i / (float)number), vec0.z + (float)z);
            ++i;
        }
        i = 0;
        while (i < corners.length) {
            if (this.pointInFrustum(corners[i]) != 0) {
                return 2;
            }
            ++i;
        }
        return 0;
    }
}

