/*
 * Decompiled with CFR 0.152.
 */
package net.comcraft.src;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Calendar;
import java.util.Vector;
import javax.microedition.io.Connector;
import javax.microedition.io.file.FileConnection;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.game.Sprite;
import net.comcraft.client.Comcraft;
import net.comcraft.src.GuiButton;
import net.comcraft.src.GuiButtonArea;
import net.comcraft.src.GuiButtonMoveControl;
import net.comcraft.src.GuiButtonPictured;
import net.comcraft.src.GuiElement;
import net.comcraft.src.GuiInGameTextBox;
import net.comcraft.src.GuiInventory;
import net.comcraft.src.GuiQuickMenu;
import net.comcraft.src.GuiScreen;
import net.comcraft.src.GuiTextBoxHost;
import net.comcraft.src.InvItemStack;
import net.comcraft.src.Keyboard;
import net.comcraft.src.ModAPI;
import net.comcraft.src.PNGEncoder;
import net.comcraft.src.Touch;

public class GuiIngame
extends GuiScreen
implements GuiTextBoxHost {
    private GuiInventory guiInventory;
    private Sprite loadingChunksSprite;
    private Image lastLoadingChunksImage;
    private GuiButton screenshotButton;

    public GuiIngame(Comcraft cc) {
        super(null, "InGame");
        this.cc = cc;
        this.elementsList = new Vector(6);
        this.guiInventory = new GuiInventory();
    }

    public void drawIngameGui() {
        if (Touch.isTouchSupported() && !Touch.isDragged() && this.cc.currentScreen == null) {
            int i = 0;
            while (i < this.elementsList.size()) {
                GuiButton guiButtonControl = (GuiButton)this.elementsList.elementAt(i);
                guiButtonControl.drawButton(null);
                ++i;
            }
        }
        this.drawFastSlotBar();
        if (!Touch.isTouchSupported() || Keyboard.hasAnyKeyBeenPressed()) {
            this.drawSelectionImage();
        }
        if (!Touch.isTouchSupported()) {
            this.cc.g.setColor(0xFFFFFF);
            if (this.cc.settings.screenshotMode) {
                GuiElement.drawStringWithShadow(this.cc.g, this.cc.langBundle.getText("Ingame.screenshotInfo"), 3, Comcraft.screenHeight - 3, 68);
            } else if (this.cc.player.commandsAllowed) {
                GuiElement.drawStringWithShadow(this.cc.g, this.cc.langBundle.getText("Ingame.commandInfo"), 3, Comcraft.screenHeight - 3, 68);
            }
        }
        if (this.cc.world.chunkProvider.getChunksQueueNum() > 0) {
            this.drawLoadingChunksImage();
        }
    }

    private void initLoadingChunksImage() {
        this.lastLoadingChunksImage = this.cc.textureProvider.getImage("gui/loading_sprite.png");
        this.loadingChunksSprite = new Sprite(this.lastLoadingChunksImage, 50, 50);
    }

    private void drawLoadingChunksImage() {
        if (this.lastLoadingChunksImage != this.cc.textureProvider.getImage("gui/loading_sprite.png")) {
            this.initLoadingChunksImage();
        }
        if (Touch.isTouchSupported()) {
            this.loadingChunksSprite.setPosition(Comcraft.screenWidth - 3 - 50, Comcraft.screenHeight - 3 - 50);
        } else {
            this.loadingChunksSprite.setPosition(Comcraft.screenWidth - 3 - 50, 3);
        }
        this.loadingChunksSprite.paint(this.cc.g);
        this.loadingChunksSprite.nextFrame();
    }

    private void drawSelectionImage() {
        this.cc.g.drawImage(this.cc.textureProvider.getImage("gui/pointer.png"), Comcraft.screenWidth / 2, Comcraft.screenHeight / 2, 3);
    }

    private void drawFastSlotBar() {
        if (Touch.isTouchSupported()) {
            int startY = (Comcraft.screenHeight - 4 * GuiButtonMoveControl.getButtonHeight()) / 2;
            int i = 0;
            while (i < 4) {
                this.drawFastSlot(i, Comcraft.screenWidth - 3 - GuiButtonMoveControl.getButtonWidth(), startY + i * GuiButtonMoveControl.getButtonHeight());
                ++i;
            }
        } else {
            int startX = (Comcraft.screenWidth - 3 * GuiButtonMoveControl.getButtonWidth()) / 2;
            int i = 0;
            while (i < 3) {
                this.drawFastSlot(i, startX + i * GuiButtonMoveControl.getButtonWidth(), 3);
                ++i;
            }
        }
    }

    private void drawFastSlot(int slotId, int x, int y) {
        if (slotId == 3) {
            this.cc.g.drawImage(this.cc.textureProvider.getImage("gui/slot_more.png"), x, y, 20);
        } else {
            InvItemStack itemStack = this.cc.player.inventory.getItemStackAt(slotId);
            if (itemStack != null) {
                this.cc.g.drawImage(this.cc.textureProvider.getItemTexture(itemStack.getItem().getIconIndex()), x, y, 20);
                Image stackImg = this.getStackSizeImage(itemStack);
                this.cc.g.drawImage(stackImg, x + 4, y + 46 - stackImg.getHeight(), 20);
            }
        }
        this.cc.g.drawImage(this.cc.textureProvider.getImage("gui/slot.png"), x, y, 20);
        if (this.cc.player.inventory.getSelectedElementNum() == slotId) {
            this.cc.g.drawImage(this.cc.textureProvider.getImage("gui/slot_selection.png"), x - 2, y - 2, 20);
        }
    }

    private Image getStackSizeImage(InvItemStack stack) {
        String text = "" + stack.stackSize;
        Font font = this.cc.g.getFont();
        int width = font.stringWidth(text);
        int height = font.getHeight();
        Image img = Image.createImage((int)width, (int)height);
        Graphics g = img.getGraphics();
        g.setColor(200, 200, 200);
        GuiElement.drawStringWithShadow(g, text, 0, 0, 20);
        int[] rgbData = new int[width * height];
        img.getRGB(rgbData, 0, width, 0, 0, width, height);
        int i = 0;
        while (i < rgbData.length) {
            if (rgbData[i] == -1) {
                rgbData[i] = 0;
            }
            ++i;
        }
        return Image.createImage((Image)Image.createRGBImage((int[])rgbData, (int)width, (int)height, (boolean)true), (int)0, (int)0, (int)width, (int)height, (int)5);
    }

    public void initIngameGui() {
        this.initLoadingChunksImage();
        if (Touch.isTouchSupported()) {
            String imageName = "gui/arrow_key.png";
            this.elementsList.addElement(new GuiButtonMoveControl(this.cc, this, 0, 0, 0, imageName, 0));
            this.elementsList.addElement(new GuiButtonMoveControl(this.cc, this, 1, 0, 0 + GuiButtonMoveControl.getButtonHeight(), imageName, 4));
            this.elementsList.addElement(new GuiButtonMoveControl(this.cc, this, 2, 0, 0 + GuiButtonMoveControl.getButtonHeight() * 2, imageName, 1));
            this.elementsList.addElement(new GuiButtonMoveControl(this.cc, this, 3, 0 + GuiButtonMoveControl.getButtonWidth(), 0 + GuiButtonMoveControl.getButtonHeight(), imageName, 5));
            this.elementsList.addElement(new GuiButtonMoveControl(this.cc, this, 4, 0, Comcraft.screenHeight - GuiButtonMoveControl.getButtonHeight(), imageName, 4));
            this.elementsList.addElement(new GuiButtonMoveControl(this.cc, this, 5, 0 + GuiButtonMoveControl.getButtonWidth(), Comcraft.screenHeight - GuiButtonMoveControl.getButtonHeight(), imageName, 5));
            int startY = (Comcraft.screenHeight - 4 * GuiButtonMoveControl.getButtonHeight()) / 2;
            int i = 0;
            while (i < 4) {
                this.elementsList.addElement(new GuiButtonArea(this, 6 + i, Comcraft.screenWidth - 3 - 50, startY + i * 50, 50, 50));
                ++i;
            }
            this.screenshotButton = new GuiButtonPictured(this.cc, this, 10, (int)((float)(Comcraft.screenWidth - GuiButtonPictured.getButtonWidth()) * 3.0f / 5.0f), Comcraft.screenHeight - GuiButtonPictured.getButtonHeight(), "gui/button_screenshot.png", 5);
            this.elementsList.addElement(this.screenshotButton);
            this.screenshotButton.drawButton = this.cc.settings.screenshotMode;
        }
    }

    public void addCommandButton() {
        if (this.cc.player.commandsAllowed) {
            GuiButtonPictured commandButton = new GuiButtonPictured(this.cc, this, 11, (int)((float)(Comcraft.screenWidth - GuiButtonPictured.getButtonWidth()) * 3.0f / 5.0f), 0, "gui/button_command.png", 5);
            this.elementsList.addElement(commandButton);
        }
    }

    public void updateScreenshotButton() {
        if (this.screenshotButton != null) {
            this.screenshotButton.drawButton = this.cc.settings.screenshotMode;
        }
    }

    protected void handleGuiAction(GuiButton guiButton) {
        if (!guiButton.enabled) {
            return;
        }
        if (guiButton.getId() == 0) {
            this.cc.player.moveEntity(1, 0, 0);
        } else if (guiButton.getId() == 1) {
            this.cc.player.moveEntity(0, 0, 1);
        } else if (guiButton.getId() == 2) {
            this.cc.player.moveEntity(-1, 0, 0);
        } else if (guiButton.getId() == 3) {
            this.cc.player.moveEntity(0, 0, -1);
        } else if (guiButton.getId() == 4) {
            this.cc.player.moveEntity(0, 1, 0);
        } else if (guiButton.getId() == 5) {
            this.cc.player.moveEntity(0, -1, 0);
        } else if (guiButton.getId() > 5 && guiButton.getId() < 9) {
            this.cc.player.inventory.setSelectedElement(guiButton.getId() - 6);
        } else if (guiButton.getId() == 9) {
            if (this.cc.currentScreen != null) {
                this.cc.displayGuiScreen(null);
            } else {
                this.cc.displayGuiScreen(this.guiInventory);
            }
        } else if (guiButton.getId() == 10) {
            this.takeScreenshot();
        } else if (guiButton.getId() == 11) {
            this.commandInput();
        }
        Touch.setInputHandled(true);
    }

    private void commandInput() {
        this.cc.displayGuiScreen(new GuiInGameTextBox(this, "", 0, 64));
    }

    private void takeScreenshot() {
        byte[] data;
        this.loadingChunksSprite.setPosition(Comcraft.screenWidth / 2 - 25, Comcraft.screenHeight / 2 - 25);
        this.loadingChunksSprite.paint(this.cc.g);
        Image blackImage = this.cc.textureProvider.getImage("gui/black.png");
        int rows = Comcraft.screenWidth / blackImage.getWidth() + 1;
        int cols = Comcraft.screenHeight / blackImage.getHeight() + 1;
        int y = 0;
        while (y < cols) {
            int x = 0;
            while (x < rows) {
                this.cc.g.drawImage(blackImage, x * blackImage.getWidth(), y * blackImage.getHeight(), 20);
                ++x;
            }
            ++y;
        }
        this.cc.flushGraphics();
        Image image = this.cc.render.getScreenshot();
        try {
            data = PNGEncoder.imageToPNG(image);
        }
        catch (IOException ex) {
            return;
        }
        Calendar cal = Calendar.getInstance();
        String fileName = "Comcraft_" + cal.get(1) + "-" + (cal.get(2) + 1) + "-" + cal.get(5) + "_" + cal.get(11) + "-" + cal.get(12) + "-" + cal.get(13) + ".png";
        try {
            FileConnection file = (FileConnection)Connector.open((String)(String.valueOf(this.cc.settings.getComcraftFileSystem().getPathToFolder("screenshots/")) + fileName), (int)3);
            if (!file.exists()) {
                file.create();
            }
            OutputStream output = file.openOutputStream();
            output.write(data);
            output.close();
            file.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    protected void handleKeyboardInput() {
        if (Keyboard.wasButtonDown(42) || Keyboard.wasButtonDown(114)) {
            if (this.cc.currentScreen != null) {
                this.cc.displayGuiScreen(null);
            } else {
                this.cc.displayGuiScreen(this.guiInventory);
            }
        } else if (Keyboard.wasButtonDown(55) || Keyboard.wasButtonDown(117)) {
            if (this.cc.player.inventory.getSelectedElementNum() > 0) {
                this.cc.player.inventory.setSelectedElement(this.cc.player.inventory.getSelectedElementNum() - 1);
            } else {
                this.cc.player.inventory.setSelectedElement(this.cc.player.inventory.getFastSlotSize() - 1);
            }
        } else if (Keyboard.wasButtonDown(57) || Keyboard.wasButtonDown(111)) {
            if (this.cc.player.inventory.getSelectedElementNum() < this.cc.player.inventory.getFastSlotSize() - 1) {
                this.cc.player.inventory.setSelectedElement(this.cc.player.inventory.getSelectedElementNum() + 1);
            } else {
                this.cc.player.inventory.setSelectedElement(0);
            }
        } else if (Keyboard.wasButtonDown(35) || Keyboard.wasButtonDown(121)) {
            if (this.cc.currentScreen != null) {
                this.cc.displayGuiScreen(new GuiQuickMenu());
            } else if (this.cc.settings.screenshotMode) {
                this.takeScreenshot();
            } else if (this.cc.player.commandsAllowed) {
                this.commandInput();
            }
        }
    }

    private boolean isPointAtFastSlotBox(int x, int y) {
        int startY = (Comcraft.screenHeight - 4 * GuiButtonMoveControl.getButtonHeight()) / 2 - 10;
        int width = GuiButtonMoveControl.getButtonWidth() + 10;
        int height = 4 * GuiButtonMoveControl.getButtonHeight() + 20;
        return x >= Comcraft.screenWidth - width && y >= startY && y <= startY + height;
    }

    protected void handleTouchInput() {
        if (Touch.isPressed() && Touch.wasUnpressed()) {
            this.touchClicked(Touch.getX(), Touch.getY());
        }
        if (this.isPointAtFastSlotBox(Touch.getX(), Touch.getY()) && !Touch.isDragged()) {
            Touch.setInputHandled(true);
        }
    }

    public void handleInput() {
        if (Touch.isTouchSupported() && (!Touch.isInputHandled() || this.cc.currentScreen == null)) {
            this.handleTouchInput();
        }
        this.handleKeyboardInput();
    }

    protected void customDrawScreen() {
    }

    protected void initGui() {
    }

    public void guiTextBoxAction(String cmd) {
        if (cmd == null) {
            return;
        }
        if (cmd.equals("")) {
            return;
        }
        ModAPI.event.runEvent("Game.Command", new Object[]{cmd, this.cc.player});
    }
}

