/*
 * Decompiled with CFR 0.152.
 */
package net.comcraft.src;

import javax.microedition.lcdui.Image;
import net.comcraft.client.Comcraft;
import net.comcraft.src.GuiElement;

public class LoadingScreen {
    private Comcraft cc;
    private String displayString;
    private float progress;

    public LoadingScreen(Comcraft cc) {
        this.cc = cc;
        this.displayString = "";
        this.progress = 0.0f;
    }

    public void displayLoadingScreen(String text) {
        this.displayString = text;
        this.progress = 0.0f;
        this.drawScreen();
    }

    public void setProgress(float progress) {
        this.progress = progress;
        this.drawScreen();
    }

    private void drawScreen() {
        this.clearScreen();
        this.drawBackground();
        this.cc.g.setColor(0xFFFFFF);
        GuiElement.drawStringWithShadow(this.cc.g, String.valueOf(this.displayString) + "..." + (int)(this.progress * 100.0f) + "%", Comcraft.screenWidth / 2, (int)((float)Comcraft.screenHeight * 0.25f), 17);
        this.drawProgressBar();
        this.cc.flushGraphics();
    }

    private void drawProgressBar() {
        int barWidth = Comcraft.screenWidth - 100;
        int barHeight = barWidth / 10;
        this.cc.g.setColor(0x696969);
        this.cc.g.drawRect((Comcraft.screenWidth - barWidth) / 2 - 1, (int)((float)Comcraft.screenHeight * 0.75f) - 1, barWidth + 2, barHeight + 2);
        this.cc.g.drawRect((Comcraft.screenWidth - barWidth) / 2 - 2, (int)((float)Comcraft.screenHeight * 0.75f) - 2, barWidth + 4, barHeight + 4);
        this.cc.g.setColor(0xFFFFFF);
        this.cc.g.fillRect((Comcraft.screenWidth - barWidth) / 2 + 1, (int)((float)Comcraft.screenHeight * 0.75f) + 1, (int)((float)(barWidth - 1) * this.progress), barHeight - 1);
    }

    private void clearScreen() {
        this.cc.g.setColor(0);
        this.cc.g.fillRect(0, 0, Comcraft.screenWidth, Comcraft.screenHeight);
    }

    private void drawBackground() {
        Image backgroundImage = this.cc.textureProvider.getImage("gui/background.png");
        int rows = Comcraft.screenWidth / backgroundImage.getWidth() + 1;
        int cols = Comcraft.screenHeight / backgroundImage.getHeight() + 1;
        int y = 0;
        while (y < cols) {
            int x = 0;
            while (x < rows) {
                this.cc.g.drawImage(backgroundImage, x * backgroundImage.getWidth(), y * backgroundImage.getHeight(), 20);
                ++x;
            }
            ++y;
        }
    }
}

