/*
 * Decompiled with CFR 0.152.
 */
package net.comcraft.src;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Hashtable;
import javax.microedition.io.Connector;
import javax.microedition.io.file.FileConnection;
import net.comcraft.src.Chunk;
import net.comcraft.src.ChunkLoader;
import net.comcraft.src.ChunkManager;
import net.comcraft.src.ChunkStorage;
import net.comcraft.src.ComcraftException;
import net.comcraft.src.LoadingScreen;
import net.comcraft.src.World;

public class LocalChunkLoader
implements ChunkLoader {
    private World world;
    private DataInputStream dataInputStream;
    private DataOutputStream dataOutputStream;
    private FileConnection file;
    private int currenPosition;
    private boolean readWriteFlag;
    private boolean isAlive;

    public LocalChunkLoader(World world, String path) {
        this.world = world;
        this.isAlive = true;
        try {
            this.openChunkLoaderStreams(path);
        }
        catch (IOException ex) {
            throw new ComcraftException("ChunkLoader <init>", ex);
        }
    }

    private void openChunkLoaderStreams(String path) throws IOException {
        this.file = (FileConnection)Connector.open((String)(String.valueOf(path) + "world.data"), (int)3);
        if (!this.file.exists()) {
            this.file.create();
        }
    }

    public void onChunkLoaderEnd() {
        this.isAlive = false;
        while (this.readWriteFlag) {
            try {
                Thread.sleep(200L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        try {
            if (this.dataInputStream != null) {
                this.dataInputStream.close();
            }
            if (this.dataOutputStream != null) {
                this.dataOutputStream.close();
            }
            this.file.close();
        }
        catch (IOException ex) {
            throw new ComcraftException("onChunkLoaderEnd", ex);
        }
    }

    public Chunk loadChunk(int x, int z) {
        return this.readChunkFromFile(x, z);
    }

    public void saveChunks(Hashtable chunksList, LoadingScreen loadingScreen) {
        this.writeChunksToFile(chunksList, loadingScreen);
    }

    private Chunk readChunkFromFile(int x, int z) {
        if (!this.isAlive) {
            return null;
        }
        this.readWriteFlag = true;
        int bytesToSkip = (x + z * this.world.worldSize) * 1024;
        if (this.dataInputStream == null || this.currenPosition > bytesToSkip) {
            try {
                if (this.dataInputStream != null) {
                    this.dataInputStream.close();
                }
                this.dataInputStream = this.file.openDataInputStream();
                this.currenPosition = 0;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        try {
            this.dataInputStream.skipBytes(bytesToSkip - this.currenPosition);
            this.currenPosition = bytesToSkip + 1024;
        }
        catch (IOException iOException) {
            // empty catch block
        }
        Chunk chunk = new Chunk(this.world, x, z);
        ChunkStorage[] blockStorage = new ChunkStorage[8];
        int i = 0;
        while (i < blockStorage.length) {
            blockStorage[i] = new ChunkStorage();
            byte[] id = new byte[64];
            byte[] metadata = new byte[64];
            try {
                this.dataInputStream.read(id);
                this.dataInputStream.read(metadata);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            blockStorage[i].setBlockIDArray(id);
            blockStorage[i].setBlockMetadataArray(metadata);
            blockStorage[i].initBlockStorage();
            ++i;
        }
        chunk.setBlockStorageArray(blockStorage);
        chunk.scanChunk();
        this.readWriteFlag = false;
        return chunk;
    }

    private void writeChunksToFile(Hashtable chunksList, LoadingScreen loadingScreen) {
        if (!this.isAlive) {
            return;
        }
        this.readWriteFlag = true;
        try {
            if (this.dataInputStream != null) {
                this.dataInputStream.close();
            }
            this.dataInputStream = this.file.openDataInputStream();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.startSavingBlockStorage();
        int z = 0;
        while (z < this.world.worldSize) {
            int x = 0;
            while (x < this.world.worldSize) {
                Chunk chunk = (Chunk)chunksList.get(ChunkManager.getChunkID(x, z, this.world.worldSize));
                if (chunk != null) {
                    try {
                        this.dataInputStream.skipBytes(1024);
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    ChunkStorage[] blockStorage = chunk.getBlockStorageArray();
                    this.saveBlockStorage(blockStorage);
                } else {
                    byte[] data = new byte[1024];
                    try {
                        this.dataInputStream.read(data);
                        ((OutputStream)this.dataOutputStream).write(data);
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                ++x;
            }
            if (loadingScreen != null) {
                loadingScreen.setProgress((float)z / (float)(this.world.worldSize - 1));
            }
            ++z;
        }
        this.endSavingBlockStorage();
        try {
            this.dataInputStream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.dataInputStream = null;
        this.readWriteFlag = false;
    }

    public void startSavingBlockStorage() {
        try {
            this.dataOutputStream = this.file.openDataOutputStream();
        }
        catch (IOException ex) {
            throw new ComcraftException("startSavingBlockStorage", ex);
        }
    }

    public void saveBlockStorage(ChunkStorage[] blockStorage) {
        if (this.dataOutputStream == null) {
            return;
        }
        int i = 0;
        while (i < 8) {
            try {
                ((OutputStream)this.dataOutputStream).write(blockStorage[i].getBlockIDArray());
                ((OutputStream)this.dataOutputStream).write(blockStorage[i].getBlockMetadataArray());
            }
            catch (IOException ex) {
                throw new ComcraftException("saveBlockStorage", ex);
            }
            ++i;
        }
    }

    public void endSavingBlockStorage() {
        try {
            this.dataOutputStream.close();
            this.dataOutputStream = null;
        }
        catch (IOException ex) {
            throw new ComcraftException("endSavingBlockStorage", ex);
        }
    }
}

