/*
 * Decompiled with CFR 0.152.
 */
package net.comcraft.src;

import com.google.minijoe.sys.JsFunction;
import com.google.minijoe.sys.JsSystem;
import com.java4ever.apime.io.GZIP;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Hashtable;
import java.util.Vector;
import javax.microedition.io.Connector;
import javax.microedition.io.file.FileConnection;
import net.comcraft.client.Comcraft;
import net.comcraft.src.FileSystemHelper;
import net.comcraft.src.Mod;
import net.comcraft.src.ModAPI;

public class ModLoader {
    public static final int API_VERSION = 6;
    public static final int MIN_API_VERSION = 6;
    private static final int PACKAGE = 16;
    private static final int MOD_DESCRIPTOR = 32;
    private static final int RESOURCE = 48;
    public static final String version = "0.6";
    private Comcraft cc;
    private Vector Mods;
    private boolean hasInitialized = false;
    private Hashtable resourcedata;
    private Hashtable packages;
    static /* synthetic */ Class class$0;

    public ModLoader(Comcraft cc) {
        this.cc = cc;
        this.Mods = new Vector();
        System.out.println("Comcraft ModLoader 0.6 Initialized");
    }

    public void initMods() {
        Vector elements;
        this.resourcedata = new Hashtable();
        if (!this.cc.settings.getComcraftFileSystem().isAvailable()) {
            System.out.println("files not initialized");
            return;
        }
        System.out.println("scanning mods folder");
        try {
            FileConnection fileConnection = (FileConnection)Connector.open((String)this.cc.settings.getComcraftFileSystem().getPathToFolder("mods/"), (int)1);
            if (!fileConnection.exists()) {
                fileConnection.mkdir();
            }
            this.hasInitialized = true;
            elements = FileSystemHelper.getElementsList(fileConnection);
            fileConnection.close();
        }
        catch (IOException ioEx) {
            ioEx.printStackTrace();
            return;
        }
        this.packages = new Hashtable(elements.size() / 2);
        ModAPI.getInstance(this.cc);
        int i = 0;
        while (i < elements.size()) {
            String elementName = (String)elements.elementAt(i);
            if (!elementName.endsWith("/") && elementName.endsWith(".mod")) {
                String modFileName = elementName.substring(elementName.lastIndexOf(47) + 1, elementName.length());
                Mod mod = new Mod(this, modFileName);
                byte[] RawData = null;
                try {
                    FileConnection GZModFile = this.open(elementName);
                    byte[] GZData = new byte[(int)GZModFile.fileSize()];
                    if (GZData.length < 20) {
                        throw new IOException("Not enough bytes in mod file");
                    }
                    GZModFile.openInputStream().read(GZData, 0, GZData.length);
                    GZModFile.close();
                    RawData = GZIP.inflate(GZData);
                }
                catch (IOException modEx) {
                    modEx.printStackTrace();
                    mod.info = modEx.getMessage();
                    mod.fatalError = true;
                }
                if (RawData != null) {
                    try {
                        this.ReadModFile(new DataInputStream(new ByteArrayInputStream(RawData)), mod);
                    }
                    catch (IOException e) {
                        mod.info = e.getMessage();
                        mod.fatalError = true;
                    }
                }
                this.Mods.addElement(mod);
            }
            ++i;
        }
        i = 0;
        while (i < this.Mods.size()) {
            ((Mod)this.Mods.elementAt(i)).initMod();
            ++i;
        }
    }

    private void ReadModFile(DataInputStream dis, Mod mod) throws IOException {
        byte[] b = new byte[4];
        dis.read(b);
        if (!new String(b).equals("CCML")) {
            throw new IOException("Malformed Mod File");
        }
        int version = dis.read();
        if (version > 6) {
            throw new IOException("Mod built for a later version of comcraft");
        }
        if (version < 6) {
            throw new IOException("Mod built for an earlier version of comcraft");
        }
        mod.info = "No Mod Info";
        int flags = dis.read();
        block6: while (dis.available() > 0) {
            int opt = dis.read();
            switch (opt) {
                case 32: {
                    mod.name = dis.readUTF();
                    mod.description = dis.readUTF();
                    mod.mainClass = dis.readUTF();
                    String ldesc = dis.readUTF();
                    if (ldesc.length() > 0) {
                        mod.info = ldesc;
                    }
                    if (!this.isDisabled(mod.mainClass)) continue block6;
                    break block6;
                }
                case 48: {
                    int l = dis.read();
                    int i = 0;
                    while (i < l) {
                        String resname = dis.readUTF();
                        String content = dis.readUTF();
                        if (!this.resourcedata.containsKey(resname)) {
                            this.resourcedata.put(resname, content);
                        }
                        ++i;
                    }
                    continue block6;
                }
                case 16: {
                    int l = dis.read();
                    int i = 0;
                    while (i < l) {
                        String packageName = dis.readUTF();
                        int flen = dis.read();
                        Hashtable<String, byte[]> files = new Hashtable<String, byte[]>(flen / 2);
                        int x = 0;
                        while (x < flen) {
                            String filename = dis.readUTF();
                            if (version >= 4 && (flags & 1) == 1) {
                                dis.readUTF();
                            }
                            int length = dis.readInt();
                            byte[] data = new byte[length];
                            dis.read(data);
                            files.put(filename, data);
                            ++x;
                        }
                        this.packages.put(packageName, files);
                        ++i;
                    }
                    continue block6;
                }
                case -1: {
                    break;
                }
                default: {
                    System.out.println("<Unknown Data " + opt + ">");
                }
            }
        }
        dis.close();
    }

    public boolean executeModInNs(String package_, String fname) throws Exception {
        Hashtable pkg;
        if (this.packages.containsKey(package_) && (pkg = (Hashtable)this.packages.get(package_)).containsKey(fname)) {
            if (pkg.get(fname) != JsSystem.JS_NULL) {
                JsFunction.exec(new DataInputStream(new ByteArrayInputStream((byte[])pkg.get(fname))), ModAPI.getInstance());
                pkg.put(fname, JsSystem.JS_NULL);
            }
            return true;
        }
        return false;
    }

    public InputStream getResourceAsStream(String filename) {
        String content = (String)this.resourcedata.get(filename);
        if (content == null) {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("java.lang.Class");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            return clazz.getResourceAsStream(filename);
        }
        return new ByteArrayInputStream(content.getBytes());
    }

    public Vector ListMods() {
        return this.Mods;
    }

    public boolean isInitialized() {
        return this.hasInitialized;
    }

    private FileConnection open(String filename) throws IOException {
        return (FileConnection)Connector.open((String)filename, (int)1);
    }

    public boolean isDisabled(String modId) {
        if (modId == null) {
            return false;
        }
        int i = 0;
        while (i < this.cc.settings.disabledMods.length) {
            String m = this.cc.settings.disabledMods[i];
            if (m != null && m.equals(modId)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public void enable(String name) {
        if (!this.isDisabled(name)) {
            return;
        }
        String[] newarr = new String[this.cc.settings.disabledMods.length - 1];
        int i = 0;
        int ni = 0;
        while (i < this.cc.settings.disabledMods.length) {
            String m = this.cc.settings.disabledMods[i];
            if (m != null && !m.equals(name)) {
                newarr[ni++] = this.cc.settings.disabledMods[i];
            }
            ++i;
        }
        this.cc.settings.disabledMods = newarr;
    }

    public void disable(String modId) {
        if (this.isDisabled(modId)) {
            return;
        }
        String[] newarr = new String[this.cc.settings.disabledMods.length + 1];
        System.arraycopy(this.cc.settings.disabledMods, 0, newarr, 0, this.cc.settings.disabledMods.length);
        newarr[newarr.length - 1] = modId;
        this.cc.settings.disabledMods = newarr;
    }
}

