/*
 * Decompiled with CFR 0.152.
 */
package net.comcraft.src;

import net.comcraft.src.Block;
import net.comcraft.src.Chunk;
import net.comcraft.src.ChunkPiece;
import net.comcraft.src.World;

public class RenderChunkPieces
extends Thread {
    private World world;
    private Chunk chunk;
    public ChunkPiece[][][] chunkPieces;
    private boolean[][][] isBlockVisibile;

    public RenderChunkPieces(World world, Chunk chunk) {
        this.chunk = chunk;
        this.world = world;
    }

    public void regenereatePieces() {
        this.chunkPieces = null;
        this.chunkPieces = new ChunkPiece[4][32][4];
        this.isBlockVisibile = this.getIsBlockVisibile();
        int z = 0;
        while (z < 4) {
            int y = 0;
            while (y < 32) {
                int x = 0;
                while (x < 4) {
                    if (this.chunkPieces[x][y][z] == null && this.isBlockVisibile[x][y][z]) {
                        this.generateMegablock(x, y, z);
                    }
                    ++x;
                }
                ++y;
            }
            ++z;
        }
    }

    private void generateMegablock(int x, int y, int z) {
        Block block = Block.blocksList[this.chunk.getBlockID(x, y, z)];
        int xSize = 0;
        int ySize = 0;
        int zSize = 0;
        if (block.canBePieced()) {
            xSize = this.getSizeX(x, y, z);
            ySize = this.getSizeY(x, y, z, xSize);
            zSize = this.getSizeZ(x, y, z, xSize, ySize);
        }
        this.fillPieces(x, y, z, xSize, ySize, zSize, block);
    }

    private void fillPieces(int x, int y, int z, int xSize, int ySize, int zSize, Block block) {
        ChunkPiece chunkPiece = new ChunkPiece((this.chunk.xPos << 2) + x, y, (this.chunk.zPos << 2) + z, xSize, ySize, zSize, block);
        int zI = 0;
        while (zI <= zSize) {
            int yI = 0;
            while (yI <= ySize) {
                int xI = 0;
                while (xI <= xSize) {
                    this.chunkPieces[x + xI][y + yI][z + zI] = chunkPiece;
                    ++xI;
                }
                ++yI;
            }
            ++zI;
        }
    }

    private int getSizeZ(int x, int y, int z, int xSize, int ySize) {
        int zSize = -1;
        int firstId = this.chunk.getBlockID(x, y, z);
        int zI = 0;
        while (z + zI < 4) {
            if (this.chunk.getBlockID(x, y, z + zI) != firstId || !this.isBlockVisibile[x][y][z + zI] || this.chunkPieces[x][y][z + zI] != null) {
                zSize = zI - 1;
                break;
            }
            if (this.getSizeY(x, y, z + zI, xSize) < ySize) {
                zSize = zI - 1;
                break;
            }
            if (z + zI == 3) {
                zSize = zI;
            }
            ++zI;
        }
        return zSize;
    }

    private int getSizeY(int x, int y, int z, int xSize) {
        int ySize = -1;
        int firstID = this.chunk.getBlockID(x, y, z);
        int yI = 0;
        while (yI < 4 && y + yI < 32) {
            if (this.chunk.getBlockID(x, y + yI, z) != firstID || !this.isBlockVisibile[x][y + yI][z] || this.chunkPieces[x][y + yI][z] != null) {
                ySize = yI - 1;
                break;
            }
            if (this.getSizeX(x, y + yI, z) < xSize) {
                ySize = yI - 1;
                break;
            }
            if (yI == 3 || y + yI == 31 || !Block.blocksList[firstID].canBePiecedVertically()) {
                ySize = yI;
                break;
            }
            ++yI;
        }
        return ySize;
    }

    private int getSizeX(int x, int y, int z) {
        int xSize = -1;
        int firstId = this.chunk.getBlockID(x, y, z);
        int xI = 0;
        while (x + xI < 4) {
            if (this.chunk.getBlockID(x + xI, y, z) != firstId || !this.isBlockVisibile[x + xI][y][z] || this.chunkPieces[x + xI][y][z] != null) {
                xSize = xI - 1;
                break;
            }
            if (x + xI == 3) {
                xSize = xI;
            }
            ++xI;
        }
        return xSize;
    }

    private boolean[][][] getIsBlockVisibile() {
        boolean[][][] blockTab = new boolean[4][32][4];
        int z = 0;
        while (z < 4) {
            int y = 0;
            while (y < 32) {
                int x = 0;
                while (x < 4) {
                    int id = this.chunk.getBlockID(x, y, z);
                    if (id != 0) {
                        Block block = Block.blocksList[id];
                        if (block.shouldSideBeRendered(this.world, (this.chunk.xPos << 2) + x + 1, y, (this.chunk.zPos << 2) + z, 0)) {
                            blockTab[x][y][z] = true;
                        } else if (block.shouldSideBeRendered(this.world, (this.chunk.xPos << 2) + x - 1, y, (this.chunk.zPos << 2) + z, 0)) {
                            blockTab[x][y][z] = true;
                        } else if (block.shouldSideBeRendered(this.world, (this.chunk.xPos << 2) + x, y + 1, (this.chunk.zPos << 2) + z, 0)) {
                            blockTab[x][y][z] = true;
                        } else if (block.shouldSideBeRendered(this.world, (this.chunk.xPos << 2) + x, y - 1, (this.chunk.zPos << 2) + z, 0)) {
                            blockTab[x][y][z] = true;
                        } else if (block.shouldSideBeRendered(this.world, (this.chunk.xPos << 2) + x, y, (this.chunk.zPos << 2) + z + 1, 0)) {
                            blockTab[x][y][z] = true;
                        } else if (block.shouldSideBeRendered(this.world, (this.chunk.xPos << 2) + x, y, (this.chunk.zPos << 2) + z - 1, 0)) {
                            blockTab[x][y][z] = true;
                        }
                    }
                    ++x;
                }
                ++y;
            }
            ++z;
        }
        return blockTab;
    }
}

