/*
 * Decompiled with CFR 0.152.
 */
package net.comcraft.src;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import javax.microedition.io.Connector;
import javax.microedition.io.file.FileConnection;
import net.comcraft.src.ChunkLoader;
import net.comcraft.src.ComcraftException;
import net.comcraft.src.EntityPlayer;
import net.comcraft.src.LevelInfo;
import net.comcraft.src.LocalChunkLoader;
import net.comcraft.src.World;
import net.comcraft.src.WorldInfo;

public class SaveInfo
implements LevelInfo {
    private String savePath;

    public SaveInfo(String savePath) {
        this.savePath = savePath;
    }

    public ChunkLoader getChunkLoader(World world) {
        return new LocalChunkLoader(world, this.savePath);
    }

    public String getSavePath() {
        return this.savePath;
    }

    public WorldInfo loadWorldInfo(EntityPlayer player) {
        try {
            FileConnection file = (FileConnection)Connector.open((String)(String.valueOf(this.savePath) + "level.info"), (int)1);
            DataInputStream dataInputStream = file.openDataInputStream();
            WorldInfo worldInfo = new WorldInfo();
            worldInfo.loadWorldInfo(dataInputStream, player);
            dataInputStream.close();
            file.close();
            return worldInfo;
        }
        catch (IOException ex) {
            throw new ComcraftException(ex);
        }
    }

    public void saveWorldInfo(WorldInfo worldInfo, EntityPlayer player) {
        try {
            FileConnection file = (FileConnection)Connector.open((String)(String.valueOf(this.savePath) + "level.info"), (int)3);
            if (!file.exists()) {
                file.create();
            }
            DataOutputStream dataOutputStream = file.openDataOutputStream();
            worldInfo.writeWorldInfo(dataOutputStream, player);
            dataOutputStream.close();
            file.close();
        }
        catch (IOException ex) {
            throw new ComcraftException(ex);
        }
    }
}

