/*
 * Decompiled with CFR 0.152.
 */
package net.comcraft.src;

import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import javax.microedition.m3g.Graphics3D;
import net.comcraft.client.Comcraft;
import net.comcraft.src.ComcraftFileSystem;
import net.comcraft.src.RMS;

public final class Settings {
    private final String recordStoreName = "comcraft_settings_1.2.3";
    private final Comcraft cc;
    private ComcraftFileSystem comcraftFileSystem;
    private RMS rms;
    public String texturepack;
    public boolean showFps;
    public boolean debugInfo;
    public int renderDistance;
    public boolean renderGui;
    public boolean fancyGraphics;
    public boolean memorySaveMode;
    public boolean ignoreOutOfMemory;
    public int autosaveTime;
    private boolean isFirstRun;
    public boolean antialiasing;
    public boolean vibrations;
    public boolean sounds;
    public boolean fog;
    public float fov;
    public String language;
    public boolean screenshotMode;
    public int resolutionScale;
    public int screenshotResolution;
    public String[] disabledMods;
    public String username;

    public Settings(Comcraft cc) {
        this.cc = cc;
        this.comcraftFileSystem = new ComcraftFileSystem(cc, null);
        this.texturepack = "Default";
        this.showFps = false;
        this.debugInfo = false;
        this.renderDistance = 1;
        this.renderGui = true;
        this.fancyGraphics = true;
        this.memorySaveMode = false;
        this.ignoreOutOfMemory = false;
        this.autosaveTime = -1;
        this.isFirstRun = false;
        this.vibrations = true;
        this.sounds = true;
        this.fov = 90.0f;
        this.fog = false;
        this.language = "/lang/en.lng";
        this.screenshotMode = false;
        this.resolutionScale = 1;
        this.screenshotResolution = 2;
        this.disabledMods = new String[0];
        this.username = "Player";
        Boolean antialiasingB = (Boolean)Graphics3D.getProperties().get("supportAntialiasing");
        this.antialiasing = antialiasingB;
        this.rms = RMS.openRecordStore("comcraft_settings_1.2.3", true);
        if (!this.rms.hasAnyRecord()) {
            this.initRecordStore(this.rms);
            this.isFirstRun = true;
        }
        this.rms.closeRecordStore();
    }

    public boolean isFirstRun() {
        return this.isFirstRun;
    }

    private void initRecordStore(RMS rms) {
        rms.addRecord();
        this.saveOptions();
    }

    public void loadOptions() {
        this.rms = RMS.openRecordStore("comcraft_settings_1.2.3", false);
        DataInputStream dataInputStream = this.rms.getRecord(1);
        try {
            this.comcraftFileSystem = new ComcraftFileSystem(this.cc, dataInputStream.readUTF());
            this.texturepack = dataInputStream.readUTF();
            this.fancyGraphics = dataInputStream.readBoolean();
            this.renderDistance = dataInputStream.readInt();
            this.memorySaveMode = dataInputStream.readBoolean();
            this.ignoreOutOfMemory = dataInputStream.readBoolean();
            this.autosaveTime = dataInputStream.readInt();
            this.antialiasing = dataInputStream.readBoolean();
            this.vibrations = dataInputStream.readBoolean();
            this.sounds = dataInputStream.readBoolean();
            this.fov = dataInputStream.readFloat();
            this.fog = dataInputStream.readBoolean();
            this.language = dataInputStream.readUTF();
            this.resolutionScale = dataInputStream.readInt();
            this.screenshotResolution = dataInputStream.readInt();
            this.readDisabledMods(dataInputStream);
            if (dataInputStream.available() > 0) {
                this.username = dataInputStream.readUTF();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            dataInputStream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.rms.closeRecordStore();
        this.comcraftFileSystem.initComcraftFileSystem();
    }

    public void saveOptions() {
        this.rms = RMS.openRecordStore("comcraft_settings_1.2.3", false);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        try {
            dataOutputStream.writeUTF(this.comcraftFileSystem.getComcraftPath());
            dataOutputStream.writeUTF(this.texturepack);
            dataOutputStream.writeBoolean(this.fancyGraphics);
            dataOutputStream.writeInt(this.renderDistance);
            dataOutputStream.writeBoolean(this.memorySaveMode);
            dataOutputStream.writeBoolean(this.ignoreOutOfMemory);
            dataOutputStream.writeInt(this.autosaveTime);
            dataOutputStream.writeBoolean(this.antialiasing);
            dataOutputStream.writeBoolean(this.vibrations);
            dataOutputStream.writeBoolean(this.sounds);
            dataOutputStream.writeFloat(this.fov);
            dataOutputStream.writeBoolean(this.fog);
            dataOutputStream.writeUTF(this.language);
            dataOutputStream.writeInt(this.resolutionScale);
            dataOutputStream.writeInt(this.screenshotResolution);
            this.writeDisabledMods(dataOutputStream);
            dataOutputStream.writeUTF(this.username);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.rms.setRecord(1, byteArrayOutputStream);
        this.rms.closeRecordStore();
    }

    public ComcraftFileSystem getComcraftFileSystem() {
        return this.comcraftFileSystem;
    }

    public void setComcraftFileSystem(ComcraftFileSystem comcraftFileSystem) {
        this.comcraftFileSystem = comcraftFileSystem;
    }

    private void readDisabledMods(DataInputStream dataInputStream) throws IOException {
        int len = dataInputStream.readShort();
        this.disabledMods = new String[len];
        int i = 0;
        while (i < len) {
            this.disabledMods[i] = dataInputStream.readUTF();
            ++i;
        }
    }

    private void writeDisabledMods(DataOutputStream dataOutputStream) throws IOException {
        String[] disMods = new String[this.disabledMods.length];
        int x = 0;
        int i = 0;
        while (i < this.disabledMods.length) {
            if (this.disabledMods[i] != null) {
                disMods[x++] = this.disabledMods[i];
            }
            ++i;
        }
        this.disabledMods = new String[x];
        System.arraycopy(disMods, 0, this.disabledMods, 0, x);
        dataOutputStream.writeShort(this.disabledMods.length);
        i = 0;
        while (i < this.disabledMods.length) {
            dataOutputStream.writeUTF(this.disabledMods[i]);
            ++i;
        }
    }
}

