/*
 * Decompiled with CFR 0.152.
 */
package net.comcraft.src;

import java.io.IOException;
import java.io.InputStream;
import java.util.Vector;
import javax.microedition.io.Connector;
import javax.microedition.io.file.FileConnection;
import net.comcraft.client.Comcraft;
import net.comcraft.src.ComcraftException;
import net.comcraft.src.FileSystemHelper;
import net.comcraft.src.TexturePack;
import net.comcraft.src.TexturePackCustom;
import net.comcraft.src.TexturePackDefault;

public class TexturePackList {
    private static final TexturePack texturepackDefault = new TexturePackDefault();
    private TexturePack selectedTexturepack;
    private final Comcraft cc;
    private Vector texturepacksList;

    public TexturePackList(Comcraft cc) {
        this.cc = cc;
        this.texturepacksList = new Vector();
        this.selectedTexturepack = texturepackDefault;
    }

    public InputStream getResourceAsStream(String resourcePath) {
        return this.selectedTexturepack.getResourceAsStream(resourcePath);
    }

    public final boolean setTexturePack(TexturePack newTexturePack) {
        if (this.selectedTexturepack.getTexturePackName().equals(newTexturePack.getTexturePackName())) {
            return false;
        }
        this.selectedTexturepack = newTexturePack;
        this.cc.textureProvider.reloadTextures();
        this.cc.render.reloadRender();
        this.cc.settings.texturepack = this.selectedTexturepack.getTexturePackName();
        this.cc.settings.saveOptions();
        return true;
    }

    public void updateAvailableTexturePacks() {
        try {
            this.texturepacksList.removeAllElements();
            this.texturepacksList.addElement(texturepackDefault);
            if (!this.cc.settings.getComcraftFileSystem().isAvailable()) {
                return;
            }
            FileConnection fileConnection = (FileConnection)Connector.open((String)this.cc.settings.getComcraftFileSystem().getPathToFolder("texturepacks/"), (int)1);
            Vector elements = FileSystemHelper.getElementsList(fileConnection);
            int i = 0;
            while (i < elements.size()) {
                TexturePackCustom texturePack;
                String elementName = (String)elements.elementAt(i);
                if ((elementName.endsWith("/") || elementName.endsWith(".zip") || elementName.endsWith(".rar")) && !(texturePack = new TexturePackCustom(this.cc, elementName)).getTexturePackName().equals("Default")) {
                    this.texturepacksList.addElement(texturePack);
                    if (this.cc.settings.texturepack.equals(texturePack.getTexturePackName())) {
                        this.setTexturePack(texturePack);
                    }
                }
                ++i;
            }
            fileConnection.close();
        }
        catch (IOException ex) {
            throw new ComcraftException(ex);
        }
    }

    public Vector getTexturepacksList() {
        return this.texturepacksList;
    }
}

