/*
 * Decompiled with CFR 0.152.
 */
package net.comcraft.client;

import com.google.minijoe.sys.JsObject;
import java.io.InputStream;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import net.comcraft.client.ComcraftMIDlet;
import net.comcraft.src.CanvasComcraft;
import net.comcraft.src.ComcraftException;
import net.comcraft.src.EntityPlayer;
import net.comcraft.src.GuiDialog;
import net.comcraft.src.GuiDialogHost;
import net.comcraft.src.GuiError;
import net.comcraft.src.GuiIngame;
import net.comcraft.src.GuiLoadingScreen;
import net.comcraft.src.GuiLoadingWorld;
import net.comcraft.src.GuiMainMenu;
import net.comcraft.src.GuiOutOfMemory;
import net.comcraft.src.GuiScreen;
import net.comcraft.src.GuiSelectPath;
import net.comcraft.src.HelloWords;
import net.comcraft.src.InputManager;
import net.comcraft.src.Keyboard;
import net.comcraft.src.LangBundle;
import net.comcraft.src.LoadingScreen;
import net.comcraft.src.ModAPI;
import net.comcraft.src.ModLoader;
import net.comcraft.src.ModelsList;
import net.comcraft.src.MusicPlayer;
import net.comcraft.src.PlayerManager;
import net.comcraft.src.RayObjectPosition;
import net.comcraft.src.Render;
import net.comcraft.src.SaveInfo;
import net.comcraft.src.ServerLoader;
import net.comcraft.src.Settings;
import net.comcraft.src.TextureManager;
import net.comcraft.src.TexturePackList;
import net.comcraft.src.Touch;
import net.comcraft.src.World;
import net.comcraft.src.WorldLoader;
import net.comcraft.src.WorldSaveType;

public final class Comcraft
extends JsObject
implements Runnable {
    public final CanvasComcraft ccCanvas;
    public final ComcraftMIDlet comcraftMIDlet;
    private long lastTime;
    public Render render;
    public GuiScreen currentScreen;
    public GuiIngame guiIngame;
    public LoadingScreen loadingScreen;
    public volatile boolean running;
    public volatile boolean isGamePaused;
    public static int screenWidth = 240;
    public static int screenHeight = 320;
    public Graphics g;
    public TexturePackList texturePackList;
    public ModLoader modLoader;
    public TextureManager textureProvider;
    public Settings settings;
    public WorldLoader worldLoader;
    public ServerLoader serverLoader;
    public World world;
    public EntityPlayer player;
    public volatile float dt;
    public volatile int tickTime;
    public PlayerManager playerManager;
    public long currentTime;
    private InputManager movementInput;
    public HelloWords helloWords;
    public LangBundle langBundle;
    public MusicPlayer musicPlayer;

    public Comcraft(ComcraftMIDlet comcraftMIDlet, CanvasComcraft ccCanvas) {
        super(JsObject.OBJECT_PROTOTYPE);
        this.comcraftMIDlet = comcraftMIDlet;
        this.ccCanvas = ccCanvas;
        ccCanvas.setComcraft(this);
        this.running = true;
        this.isGamePaused = true;
        this.texturePackList = null;
        this.settings = null;
        this.g = null;
        this.currentScreen = null;
        this.textureProvider = null;
        this.modLoader = new ModLoader(this);
        this.textureProvider = new TextureManager(this);
        this.texturePackList = new TexturePackList(this);
        this.world = null;
        this.guiIngame = null;
        this.render = null;
        this.loadingScreen = new LoadingScreen(this);
        this.langBundle = new LangBundle(this);
        this.render = new Render(this);
        this.musicPlayer = new MusicPlayer(this);
    }

    public static int getScreenWidth() {
        return screenWidth;
    }

    public static int getScreenHeight() {
        return screenHeight;
    }

    private void initScreenSize() {
        int width = this.ccCanvas.getWidth();
        int height = this.ccCanvas.getHeight();
        int[][] tab = new int[][]{{480, 800}, {480, 640}, {360, 640}, {360, 480}, {320, 480}, {320, 240}, {240, 400}, {240, 320}, {176, 220}};
        int n = 0;
        while (n < tab.length) {
            if (width >= tab[n][0] && height >= tab[n][1]) {
                screenWidth = tab[n][0];
                screenHeight = tab[n][1];
                break;
            }
            ++n;
        }
        System.out.println("Screen width: " + screenWidth);
        System.out.println("Screen height: " + screenHeight);
        this.addVar("screenWidth", new Integer(screenWidth));
        this.addVar("screenHeight", new Integer(screenHeight));
    }

    public void openUrl(String url) {
        this.comcraftMIDlet.openUrl(url);
    }

    private void updateDt() {
        this.currentTime = System.currentTimeMillis();
        this.tickTime = (int)(this.currentTime - this.lastTime);
        this.dt = (float)this.tickTime / 1000.0f;
        this.lastTime = this.currentTime;
    }

    private void setDesiredFont() {
        Font font = Font.getFont((int)0, (int)0, (int)0);
        this.g.setFont(font);
    }

    public void startGame() {
        this.g = this.ccCanvas.getGraphics();
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException ex) {
            ex.printStackTrace();
        }
        this.initScreenSize();
        this.g.setClip(0, 0, screenWidth, screenHeight);
        this.g.setColor(0);
        this.g.fillRect(0, 0, screenWidth, screenHeight);
        this.setDesiredFont();
        this.settings = new Settings(this);
        this.loadScreen();
        ModelsList.initModelList();
        this.settings.loadOptions();
        this.modLoader.initMods();
        this.langBundle.setDefaultMap("/lang/en.lng");
        this.langBundle.loadBundle(this.settings.language);
        if (!this.settings.getComcraftFileSystem().isAvailable()) {
            this.displayGuiScreen(new GuiSelectPath(this.currentScreen));
        }
        this.render.initRender();
        this.worldLoader = new WorldLoader(this);
        this.serverLoader = new ServerLoader(this);
        this.texturePackList.updateAvailableTexturePacks();
        this.textureProvider.reloadTextures();
        this.render.reloadRender();
        this.helloWords = new HelloWords(this);
        this.musicPlayer.loadMusicList();
        this.movementInput = new InputManager(this);
        if (this.currentScreen == null) {
            this.displayGuiScreen(new GuiMainMenu());
        }
        this.showScreenVisit();
    }

    public void loadScreen() {
        GuiLoadingScreen guiScreen = new GuiLoadingScreen();
        guiScreen.initGuiScreen(this);
        guiScreen.drawScreen();
        this.flushGraphics();
    }

    private void showScreenVisit() {
        this.g.setColor(255, 255, 255);
        this.g.fillRect(0, 0, screenWidth, screenHeight);
        this.g.setColor(0, 0, 0);
        this.g.drawString("Visit:", screenWidth / 2, screenHeight / 2 - 10, 17);
        this.g.drawString("comcraft-game.blogspot.com", screenWidth / 2, screenHeight / 2 + 10, 17);
        this.flushGraphics();
        try {
            Thread.sleep(3500L);
        }
        catch (InterruptedException ex) {
            ex.printStackTrace();
            throw new ComcraftException(ex);
        }
    }

    public void flushGraphics() {
        this.ccCanvas.flushGraphics();
    }

    public void shutdown() {
        this.settings.saveOptions();
        this.running = false;
        this.shutdownComcraftMIDlet();
    }

    private void shutdownComcraftMIDlet() {
        this.comcraftMIDlet.notifyDestroyed();
    }

    public String getMIDletSize() {
        if (this.comcraftMIDlet.getAppProperty("MIDlet-Jar-Size") == null) {
            throw new ComcraftException("MIDlet-Jar-Size error", null);
        }
        return this.comcraftMIDlet.getAppProperty("MIDlet-Jar-Size");
    }

    public void run() {
        try {
            this.startGame();
        }
        catch (SecurityException ex) {
            this.displayGuiScreen(new GuiDialog(new GuiDialogHost(){

                public void dialogAction() {
                    Comcraft.this.shutdown();
                }
            }, this.langBundle.getText("GuiDialog.readWriteFilesError")));
        }
        catch (ComcraftException ex) {
            this.displayGuiScreen(new GuiError(ex));
        }
        catch (OutOfMemoryError error) {
            this.outOfMemoryErrorAction(error);
        }
        catch (Exception ex) {
            this.displayGuiScreen(new GuiError(ex));
        }
        while (this.running) {
            try {
                if (!this.ccCanvas.visibile) continue;
                this.runTick();
            }
            catch (SecurityException ex) {
                this.displayGuiScreen(new GuiDialog(new GuiDialogHost(){

                    public void dialogAction() {
                        Comcraft.this.shutdown();
                    }
                }, this.langBundle.getText("GuiDialog.readWriteFilesError")));
            }
            catch (ComcraftException ex) {
                this.displayGuiScreen(new GuiError(ex));
            }
            catch (OutOfMemoryError error) {
                this.outOfMemoryErrorAction(error);
            }
            catch (Exception ex) {
                if (this.world != null) {
                    this.world.saveWorld(this.loadingScreen);
                }
                this.displayGuiScreen(new GuiError(ex));
            }
        }
    }

    private void outOfMemoryErrorAction(OutOfMemoryError error) {
        if (this.settings.ignoreOutOfMemory) {
            return;
        }
        this.textureProvider.releaseTextures();
        this.render.releaseRender();
        System.gc();
        try {
            Thread.sleep(3000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (this.world != null && !this.isGamePaused) {
            this.world.saveWorld(this.loadingScreen);
            this.world.onWorldEnd();
            this.world = null;
        }
        this.displayGuiScreen(new GuiOutOfMemory(error));
    }

    private void processInput() {
        Touch.tickTouch();
        Keyboard.tickKeyboard();
        boolean checked = false;
        while (!(checked && Keyboard.isQueueEmpty() && Touch.isQueueEmpty())) {
            checked = true;
            if (this.currentScreen != null) {
                this.currentScreen.handleInput();
            }
            if (!this.isGamePaused) {
                this.guiIngame.handleInput();
                this.movementInput.handleInput();
            }
            Keyboard.tickKeyboard();
            Touch.tickTouch();
        }
    }

    private void runTick() {
        this.updateDt();
        this.musicPlayer.tickMusicPlayer();
        if (this.serverLoader.game != null) {
            this.serverLoader.game.processAnyPackets();
        }
        if (!this.isGamePaused) {
            this.player.onLivingUpdate(this.dt);
            if (this.settings.memorySaveMode) {
                this.world.chunkProvider.releaseUnusedChunks();
            }
            if (this.settings.autosaveTime != -1) {
                this.world.checkAutosave();
            }
        }
        this.processInput();
        if (!this.isGamePaused) {
            this.world.getWorldUpdater().updateWorld((int)(this.dt * 1000.0f));
            this.render.renderEffects.tickEffects();
        }
        this.render.renderAll();
    }

    public void onClick(int mode, RayObjectPosition rayObject) {
        if (rayObject == null) {
            return;
        }
        if (rayObject.typeOfHit == 0) {
            if (mode == 0) {
                this.playerManager.clickBlock(rayObject.blockX, rayObject.blockY, rayObject.blockZ, rayObject.sideHit);
            } else {
                this.playerManager.onPlayerRightClick(this.player, this.world, this.player.inventory.getSelectedItemStack(), rayObject.blockX, rayObject.blockY, rayObject.blockZ, rayObject.sideHit);
            }
        }
    }

    public void displayGuiScreen(GuiScreen newGuiScreen) {
        if (this.currentScreen != null) {
            this.currentScreen.onScreenClosed();
        }
        if (newGuiScreen != null) {
            ModAPI.event.runEvent("Comcraft.displayScreen", new Object[]{newGuiScreen});
            Object retval = ModAPI.event.getLastSuccess("Comcraft.displayScreen");
            if (retval instanceof GuiScreen) {
                newGuiScreen = (GuiScreen)retval;
            }
        }
        this.currentScreen = newGuiScreen;
        if (this.currentScreen != null) {
            if (!this.currentScreen.isScreenInitialized()) {
                this.currentScreen.initGuiScreen(this);
            }
            this.currentScreen.onScreenDisplay();
            if (this.currentScreen.doesGuiPauseGame()) {
                this.isGamePaused = true;
            }
        }
    }

    public void vibrate(int time) {
        if (this.settings.vibrations) {
            this.comcraftMIDlet.display.vibrate(time);
        }
    }

    public void startWorld(WorldSaveType worldInfo) {
        this.guiIngame = new GuiIngame(this);
        this.guiIngame.initIngameGui();
        this.isGamePaused = false;
        SaveInfo saveHandler = this.worldLoader.getSaveLoader(worldInfo.getWorldName());
        this.player = this.playerManager.createPlayer();
        this.world = new World(this, saveHandler);
        this.guiIngame.addCommandButton();
        this.displayGuiScreen(new GuiLoadingWorld());
    }

    public void endWorld() {
        this.isGamePaused = true;
        this.displayGuiScreen(new GuiMainMenu());
        if (this.world != null) {
            this.world.saveWorld(this.loadingScreen);
            this.world.onWorldEnd();
            this.world = null;
        }
    }

    public static String getPlatform() {
        return System.getProperty("microedition.platform");
    }

    public static String getImei() {
        String imei = null;
        try {
            if (imei == null) {
                imei = System.getProperty("imei");
            }
            if (imei == null) {
                imei = System.getProperty("phone.imei");
            }
            if (imei == null) {
                imei = System.getProperty("com.nokia.IMEI");
            }
            if (imei == null) {
                imei = System.getProperty("com.nokia.mid.imei");
            }
            if (imei == null) {
                imei = System.getProperty("com.sonyericsson.imei");
            }
            if (imei == null) {
                imei = System.getProperty("IMEI");
            }
            if (imei == null) {
                imei = System.getProperty("com.motorola.IMEI");
            }
            if (imei == null) {
                imei = System.getProperty("com.samsung.imei");
            }
            if (imei == null) {
                imei = System.getProperty("com.siemens.imei");
            }
            if (imei == null) {
                imei = System.getProperty("com.lge.imei");
            }
            if (imei == null) {
                imei = System.getProperty("sim.imei");
            }
            if (imei == null) {
                imei = System.getProperty("microedition.imei");
            }
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        if (imei == null) {
            imei = "Unknown";
        }
        return imei;
    }

    public InputStream getResourceAsStream(String filename) {
        return this.modLoader.getResourceAsStream(filename);
    }
}

