/*
 * Decompiled with CFR 0.152.
 */
package net.comcraft.src;

import javax.microedition.m3g.IndexBuffer;
import javax.microedition.m3g.VertexBuffer;
import net.comcraft.src.AxisAlignedBB;
import net.comcraft.src.Block;
import net.comcraft.src.ModelPlayer;
import net.comcraft.src.World;

public class BlockPlayer
extends Block {
    private int texFront = 3;
    private int texBack = 2;
    private int texArms = 4;
    private int texHair = 0;
    private int texFeet = 1;

    public BlockPlayer() {
        super(255);
    }

    public int[] getUsedTexturesList() {
        return new int[]{this.texFront, this.texBack, this.texArms, this.texHair, this.texFeet};
    }

    public int getBlockTexture(World world, int x, int y, int z, int side) {
        if (side == 0) {
            return this.texFront;
        }
        if (side == 1) {
            return this.texBack;
        }
        if (side == 2 || side == 3) {
            return this.texArms;
        }
        if (side == 4) {
            return this.texHair;
        }
        return this.texFeet;
    }

    public boolean collidesWithPlayer() {
        return false;
    }

    public int getRenderType() {
        return 10;
    }

    public boolean doesBlockDestroyGrass() {
        return false;
    }

    public boolean canBePieced() {
        return false;
    }

    public boolean canBePiecedVertically() {
        return false;
    }

    public VertexBuffer[][][][] getBlockVertexBufferPieced(World world, int x, int y, int z) {
        return ModelPlayer.vertexBuffer;
    }

    public IndexBuffer getBlockIndexBuffer() {
        return ModelPlayer.indexBuffer;
    }

    public AxisAlignedBB getCollisionBoundingBoxFromPool(World world, int x, int y, int z) {
        return AxisAlignedBB.getBoundingBox(x, y, z, (float)x + 1.0f, (float)y + 2.0f, (float)z + 1.0f);
    }

    public boolean canPlaceBlockAt(World world, int x, int y, int z) {
        return true;
    }

    public boolean shouldSideBeRendered(World world, int x, int y, int z, int side) {
        return true;
    }
}

