/*
 * Decompiled with CFR 0.152.
 */
package net.comcraft.src;

import net.comcraft.src.Block;
import net.comcraft.src.EntityPlayer;
import net.comcraft.src.World;

public class BlockPumpkin
extends Block {
    private int indexFront;
    private int indexSide;
    private int indexTop;
    private int indexBottom;

    public BlockPumpkin(int id, int indexFront, int indexSide, int indexTop, int indexBottom) {
        super(id);
        this.indexFront = indexFront;
        this.indexSide = indexSide;
        this.indexTop = indexTop;
        this.indexBottom = indexBottom;
    }

    public int[] getUsedTexturesList() {
        return new int[]{this.indexFront, this.indexSide, this.indexTop, this.indexBottom};
    }

    public boolean canBePieced() {
        return false;
    }

    public int getRenderType() {
        return 0;
    }

    public int getBlockTexture(World world, int x, int y, int z, int side) {
        if (world != null && side == world.getBlockMetadata(x, y, z) || world == null && side == 0) {
            return this.indexFront;
        }
        if (side == 4) {
            return this.indexTop;
        }
        if (side == 5) {
            return this.indexBottom;
        }
        return this.indexSide;
    }

    public void onBlockPlacedBy(World world, int x, int y, int z, EntityPlayer entityPlayer) {
        int metadata = entityPlayer.rotationYaw >= 45.0f && entityPlayer.rotationYaw <= 135.0f ? 3 : (entityPlayer.rotationYaw >= 135.0f && entityPlayer.rotationYaw <= 225.0f ? 1 : (entityPlayer.rotationYaw >= 225.0f && entityPlayer.rotationYaw <= 315.0f ? 2 : 0));
        world.setBlockMetadata(x, y, z, metadata);
    }
}

