/*
 * Decompiled with CFR 0.152.
 */
package net.comcraft.src;

import java.io.IOException;
import java.util.Vector;
import javax.microedition.io.Connector;
import javax.microedition.io.file.FileConnection;
import javax.microedition.io.file.FileSystemRegistry;
import net.comcraft.src.ComcraftException;
import net.comcraft.src.FileSystemHelper;

public final class FileBrowser {
    private String currentPath;
    private Vector currentElements = new Vector();

    public void openDirectory(String path) {
        if (!FileSystemHelper.isDirectory(path)) {
            return;
        }
        if (path.equals("file:///")) {
            this.openRoot();
        } else {
            this.openFolder(path);
        }
        this.currentPath = path;
    }

    private void openRoot() {
        this.currentElements = FileSystemHelper.getElementsList(FileSystemRegistry.listRoots());
    }

    private void openFolder(String path) {
        try {
            FileConnection fileConnection = (FileConnection)Connector.open((String)path, (int)1);
            if (fileConnection.exists()) {
                this.currentElements = FileSystemHelper.getElementsList(fileConnection);
            }
            fileConnection.close();
        }
        catch (IOException ex) {
            throw new ComcraftException("IOException while entering selected directory!", ex);
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
    }

    public void openPreviousFolder() {
        String path = this.currentPath;
        if (path.equals("file:///")) {
            return;
        }
        path = path.substring(0, path.length() - 1);
        while (!FileSystemHelper.isDirectory(path)) {
            path = path.substring(0, path.length() - 1);
        }
        this.openDirectory(path);
    }

    public boolean canWriteCurrentDirectory() {
        return !this.currentPath.equals("file:///");
    }

    public String getCurrentPath() {
        return this.currentPath;
    }

    public Vector getCurrentElements() {
        return this.currentElements;
    }
}

