/*
 * Decompiled with CFR 0.152.
 */
package net.comcraft.src;

import com.google.minijoe.sys.JsArray;
import com.google.minijoe.sys.JsException;
import com.google.minijoe.sys.JsObject;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.game.Sprite;
import net.comcraft.client.Comcraft;
import net.comcraft.src.GuiElement;
import net.comcraft.src.Touch;

public class GuiButton
extends GuiElement {
    private Sprite buttonSprite = null;
    protected Comcraft cc;
    protected int id;
    public int xPos;
    public int yPos;
    public String displayString;
    public boolean enabled;
    public boolean drawButton;
    private Image buttonImage;
    private static final int ID_GET_BUTTON_HEIGHT = 150;
    private static final int ID_GET_BUTTON_WIDTH = 151;
    private static final int ID_GET_ID = 152;
    public static final JsObject GUIBUTTON_PROTOTYPE = new GuiButton(null).addNative("buttonHeight", 150, 0).addNative("buttonWidth", 151, 0).addNative("getId", 152, 0);

    public GuiButton(Comcraft cc, int id, int x, int y, String displayString) {
        this(cc, id, x, y);
        this.displayString = displayString;
        this.initButtonSprite();
    }

    protected GuiButton(Comcraft cc, int id, int x, int y) {
        this(cc);
        this.id = id;
        this.xPos = x;
        this.yPos = y;
    }

    public GuiButton(Comcraft cc) {
        super(GUIBUTTON_PROTOTYPE);
        this.cc = cc;
        this.enabled = true;
        this.drawButton = true;
    }

    public final int getId() {
        return this.id;
    }

    public final GuiButton setEnabled(boolean flag) {
        this.enabled = flag;
        return this;
    }

    protected Image getButtonImage() {
        return this.cc.textureProvider.getImage("gui/button.png");
    }

    protected final void initButtonSprite() {
        this.buttonImage = this.getButtonImage();
        if (this.buttonImage != null) {
            this.buttonSprite = new Sprite(this.buttonImage, this.getWidth(), this.getHeight());
        }
    }

    protected int getHooverState(boolean point) {
        int isOver = 1;
        if (point) {
            isOver = 2;
        } else if (!this.enabled) {
            return 0;
        }
        return isOver;
    }

    public void drawButton(GuiButton selectedButton) {
        if (!this.drawButton) {
            if (!Touch.isInputHandled() && Touch.isPressed() && this.checkPoint(Touch.getX(), Touch.getY())) {
                Touch.setInputHandled();
            }
            return;
        }
        if (this.getButtonImage() != this.buttonImage) {
            this.initButtonSprite();
        }
        boolean flag = false;
        if ((!Touch.isInputHandled() || this.cc.currentScreen == null) && Touch.isPressed() && this.checkPoint(Touch.getX(), Touch.getY())) {
            flag = true;
        } else if (selectedButton == this) {
            flag = true;
        }
        int i = this.getHooverState(flag);
        int y = this.yPos;
        if (selectedButton != null && selectedButton.yPos + selectedButton.getHeight() > Comcraft.screenHeight) {
            y -= selectedButton.yPos + selectedButton.getHeight() - Comcraft.screenHeight + 10;
        }
        this.buttonSprite.setPosition(this.xPos, y);
        this.buttonSprite.setFrame(i);
        this.buttonSprite.paint(this.cc.g);
        this.drawButtonString(flag, y);
    }

    protected void drawButtonString(boolean flag, int y) {
        if (!this.enabled) {
            this.cc.g.setColor(100, 100, 100);
        } else if (flag) {
            this.cc.g.setColor(255, 255, 0);
        } else {
            this.cc.g.setColor(220, 220, 220);
        }
        GuiElement.drawStringWithShadow(this.cc.g, this.getDisplayString(), this.xPos + this.getWidth() / 2, y + this.getHeight() / 2 - this.cc.g.getFont().getHeight() / 2, 17);
    }

    protected String getDisplayString() {
        return this.displayString;
    }

    public boolean checkPoint(int x, int y) {
        return this.enabled && x > this.xPos && y > this.yPos && x <= this.xPos + this.getWidth() && y <= this.yPos + this.getHeight();
    }

    protected int getWidth() {
        return GuiButton.getButtonWidth();
    }

    protected int getHeight() {
        return GuiButton.getButtonHeight();
    }

    public static int getButtonWidth() {
        if (Comcraft.getScreenWidth() == 240) {
            return 180;
        }
        if (Comcraft.getScreenWidth() == 360) {
            return 280;
        }
        if (Comcraft.getScreenWidth() == 320 && Comcraft.getScreenHeight() == 240) {
            return 180;
        }
        if (Comcraft.getScreenWidth() == 320) {
            return 280;
        }
        if (Comcraft.getScreenWidth() == 480) {
            return 280;
        }
        if (Comcraft.getScreenWidth() == 176) {
            return 160;
        }
        return -1;
    }

    public static int getButtonHeight() {
        if (Comcraft.getScreenWidth() == 240) {
            return 30;
        }
        if (Comcraft.getScreenWidth() == 360) {
            return 45;
        }
        if (Comcraft.getScreenWidth() == 320 && Comcraft.getScreenHeight() == 240) {
            return 30;
        }
        if (Comcraft.getScreenWidth() == 320) {
            return 45;
        }
        if (Comcraft.getScreenWidth() == 480) {
            return 45;
        }
        if (Comcraft.getScreenWidth() == 176) {
            return 30;
        }
        return -1;
    }

    public void evalNative(int id, JsArray stack, int sp, int parCount) {
        if (id == 100) {
            if (parCount < 3) {
                throw new JsException((Object)"[new GuiButton()] not enough arguments provided");
            }
            this.id = stack.getInt(sp + 2);
            this.xPos = stack.getInt(sp + 3);
            this.yPos = stack.getInt(sp + 4);
            if (parCount >= 4) {
                this.displayString = stack.getString(sp + 5);
            }
        } else if (id == 150) {
            stack.setInt(sp, GuiButton.getButtonHeight());
        } else if (id == 151) {
            stack.setInt(sp, GuiButton.getButtonWidth());
        } else if (id == 152) {
            stack.setInt(sp, this.getId());
        } else {
            super.evalNative(id, stack, sp, parCount);
        }
    }
}

