/*
 * Decompiled with CFR 0.152.
 */
package net.comcraft.src;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Hashtable;
import javax.microedition.io.Connector;
import javax.microedition.io.SocketConnection;
import net.comcraft.client.Comcraft;
import net.comcraft.src.Chunk;
import net.comcraft.src.ChunkLoader;
import net.comcraft.src.ChunkStorage;
import net.comcraft.src.EntityPlayer;
import net.comcraft.src.GuiIngame;
import net.comcraft.src.GuiLoadingWorld;
import net.comcraft.src.GuiServerMessage;
import net.comcraft.src.InvItemStack;
import net.comcraft.src.LevelInfo;
import net.comcraft.src.LoadingScreen;
import net.comcraft.src.Packet;
import net.comcraft.src.PacketBlockChange;
import net.comcraft.src.PacketChunkData;
import net.comcraft.src.PacketDisconnect;
import net.comcraft.src.PacketLogin;
import net.comcraft.src.PacketPlayerData;
import net.comcraft.src.PacketWorldInfo;
import net.comcraft.src.PlayerManagerImp;
import net.comcraft.src.Vec3D;
import net.comcraft.src.World;
import net.comcraft.src.WorldInfo;

public class ServerGame
implements ChunkLoader,
LevelInfo {
    private SocketConnection client;
    private DataInputStream dis;
    private DataOutputStream dos;
    private Comcraft cc;
    private boolean isAlive;
    private boolean ignoreChange = false;
    private boolean closing = false;
    private RecieveThread reciever;
    private SendThread sender;
    private WorldInfo worldInfo;
    private GuiServerMessage guiscr;
    private Chunk chunk = null;
    private World world;
    public static final int serverCompatVer = 2;
    private Hashtable onlinePlayers;
    private int id;
    private boolean blockInvChange;

    public ServerGame(Comcraft cc, String ip) {
        this.cc = cc;
        this.guiscr = new GuiServerMessage(cc.currentScreen, this);
        cc.displayGuiScreen(this.guiscr);
        if (this.connect(ip)) {
            this.guiscr.setText(cc.langBundle.getText("ServerGame.login"));
            PacketLogin login = new PacketLogin(Comcraft.getImei(), cc.settings.username);
            this.id = login.uniqueId;
            this.sender.sendPacket(login);
        } else {
            this.client = null;
        }
    }

    public boolean connect(String ip) {
        this.guiscr.setText(this.cc.langBundle.getText("ServerGame.connecting"));
        try {
            this.client = (SocketConnection)Connector.open((String)("socket://" + ip));
            if (this.client == null) {
                throw new IOException();
            }
        }
        catch (IOException e) {
            this.guiscr.setText(this.cc.langBundle.getText("ServerGame.error.connect"));
            this.guiscr.buttonSetBack();
            return false;
        }
        try {
            this.client.setSocketOption((byte)2, 1);
            this.client.setSocketOption((byte)0, 0);
            this.dis = this.client.openDataInputStream();
            this.dos = this.client.openDataOutputStream();
            this.reciever = new RecieveThread();
            this.sender = new SendThread();
            new Thread(this.reciever).start();
            new Thread(this.sender).start();
        }
        catch (IOException e) {
            try {
                this.client.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.guiscr.setText(this.cc.langBundle.getText("ServerGame.error.init"));
            return false;
        }
        return true;
    }

    public boolean hasConnected() {
        return this.client != null;
    }

    protected void disconnect() {
        this.closing = true;
        try {
            this.dis.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            this.dos.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            this.client.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.cc.serverLoader.game = null;
    }

    public void begin() {
        this.cc.playerManager = new PlayerManagerImp(this.cc);
        this.onlinePlayers = new Hashtable();
        this.sender.sendPacket(new PacketWorldInfo());
        this.startWorld();
    }

    private void startWorld() {
        this.cc.guiIngame = new GuiIngame(this.cc);
        this.cc.guiIngame.initIngameGui();
        this.cc.player = new EntityPlayer(this.cc, this);
        this.cc.guiIngame.addCommandButton();
    }

    public WorldInfo loadWorldInfo(EntityPlayer player) {
        return this.worldInfo;
    }

    public void saveWorldInfo(WorldInfo worldInfo, EntityPlayer player) {
        this.injectDisconnectPacket();
    }

    public ChunkLoader getChunkLoader(World world) {
        this.isAlive = true;
        this.world = world;
        return this;
    }

    public void onChunkLoaderEnd() {
        this.isAlive = false;
        this.disconnect();
    }

    public Chunk loadChunk(int x, int z) {
        if (!this.isAlive) {
            return null;
        }
        this.sender.sendPacket(new PacketChunkData(x, z));
        while (this.chunk == null && this.isAlive) {
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        Chunk c = this.chunk;
        this.chunk = null;
        return c;
    }

    public void saveChunks(Hashtable chunksMap, LoadingScreen loadingScreen) {
    }

    public void blockChanged(Chunk chunk, int x, int y, int z, int id, int metadata) {
        if (this.ignoreChange) {
            this.ignoreChange = false;
            return;
        }
        this.sender.sendPacket(new PacketBlockChange(chunk, x, y, z, id, metadata));
    }

    public void processAnyPackets() {
        this.reciever.processNext(this);
    }

    public void handleWorldInfo(DataInputStream dis) {
        this.blockInvChange = true;
        this.worldInfo = new WorldInfo();
        try {
            this.worldInfo.loadWorldInfo(dis, this.cc.player);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.blockInvChange = false;
        this.cc.world = new World(this.cc, this);
        this.cc.displayGuiScreen(new GuiLoadingWorld());
        this.cc.isGamePaused = false;
    }

    private void quitServer(String reason) {
        this.cc.isGamePaused = true;
        this.closing = true;
        this.guiscr.setText(reason);
        this.guiscr.buttonSetBack();
        this.cc.displayGuiScreen(this.guiscr);
        if (this.cc.world != null) {
            this.cc.world.onWorldEnd();
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.cc.world = null;
        }
    }

    public void handleBlockChange(PacketBlockChange p) {
        Chunk chunk = this.cc.world.getChunkFromChunkCoords(p.chunkX, p.chunkZ);
        this.ignoreChange = true;
        chunk.setBlockIDWithMetadata(p.x, p.y, p.z, p.id, p.metadata);
    }

    public void handleChunkData(byte[] data, int x, int z) {
        Chunk chunk = new Chunk(this.world, x, z);
        ChunkStorage[] blockStorage = new ChunkStorage[8];
        int index = 0;
        int i = 0;
        while (i < blockStorage.length) {
            blockStorage[i] = new ChunkStorage();
            byte[] id = new byte[64];
            byte[] metadata = new byte[64];
            System.arraycopy(data, index, id, 0, id.length);
            System.arraycopy(data, index + 64, metadata, 0, metadata.length);
            blockStorage[i].setBlockIDArray(id);
            blockStorage[i].setBlockMetadataArray(metadata);
            blockStorage[i].initBlockStorage();
            index += 128;
            ++i;
        }
        chunk.setBlockStorageArray(blockStorage);
        this.chunk = chunk;
    }

    private void injectDisconnectPacket() {
        try {
            this.sender.writeToStream(new PacketDisconnect(this.cc.player));
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void handleDisconnect(String reason, PacketDisconnect p) {
        this.injectDisconnectPacket();
        this.quitServer(reason);
    }

    public void handlePlayerMove(int playerId, Vec3D newPos) {
        this.ignoreChange = true;
        EntityPlayer player = (EntityPlayer)this.onlinePlayers.get(new Integer(playerId));
        Vec3D oldPos = player.getPosition();
        this.cc.world.setBlockID((int)oldPos.x, (int)oldPos.y, (int)oldPos.z, 0);
        this.ignoreChange = true;
        this.cc.world.setBlockID((int)newPos.x, (int)newPos.y, (int)newPos.z, 255);
        player.xPos = newPos.x;
        player.yPos = newPos.y;
        player.zPos = newPos.z;
    }

    public void handleNewPlayer(int playerId, Vec3D pos) {
        this.onlinePlayers.put(new Integer(playerId), new EntityPlayer(this.cc));
        this.handlePlayerMove(playerId, pos);
    }

    public void handlePlayerQuit(int playerId) {
        EntityPlayer player = (EntityPlayer)this.onlinePlayers.get(new Integer(playerId));
        Vec3D pos = player.getPosition();
        this.cc.world.setBlockID((int)pos.x, (int)pos.y, (int)pos.z, 0);
        this.onlinePlayers.remove(player);
    }

    public void playerMoved(EntityPlayer player) {
        this.sender.sendPacket(new PacketPlayerData(this.id, player.getPosition()));
    }

    public void playerInventoryChanged(int index, InvItemStack itemStack) {
        if (!this.blockInvChange) {
            this.sender.sendPacket(new PacketPlayerData(index, itemStack));
        }
    }

    public void handleInventoryChange(int index, InvItemStack itemStack) {
        this.blockInvChange = true;
        this.cc.player.inventory.setItemStackAt(index, itemStack);
        this.blockInvChange = false;
    }

    class RecieveThread
    implements Runnable {
        private Packet[] stack;

        RecieveThread() {
            this.resetStack();
        }

        public void processNext(ServerGame handler) {
            if (this.stack.length == 0) {
                return;
            }
            int i = 0;
            while (i < this.stack.length) {
                if (this.stack[i] != null && !ServerGame.this.closing) {
                    this.stack[i].process(handler);
                    this.stack[i] = null;
                    return;
                }
                ++i;
            }
            this.resetStack();
        }

        private void resetStack() {
            this.stack = new Packet[0];
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            try {
                while (true) {
                    if (ServerGame.this.closing) {
                        return;
                    }
                    this.recieveStream();
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
            catch (IOException e) {
                ServerGame.this.quitServer(((ServerGame)ServerGame.this).cc.langBundle.getText("ServerGame.error.conLost"));
            }
        }

        private void recieveStream() throws IOException {
            int size;
            try {
                size = ServerGame.this.dis.read() & 0xFF;
            }
            catch (IOException e) {
                if (ServerGame.this.closing) {
                    return;
                }
                throw e;
            }
            Packet[] newStack = new Packet[this.stack.length + size];
            System.arraycopy(this.stack, 0, newStack, 0, this.stack.length);
            int i = 0;
            while (i < size) {
                Packet p = Packet.getNewPacket(new Integer(ServerGame.this.dis.read() & 0xFF));
                p.readData(ServerGame.this.dis);
                newStack[this.stack.length + i] = p;
                ++i;
            }
            this.stack = newStack;
        }
    }

    class SendThread
    implements Runnable {
        private Packet[] queue;

        SendThread() {
            this.resetQueue();
        }

        private void resetQueue() {
            this.queue = new Packet[0];
        }

        public void run() {
            try {
                int i = 0;
                while (!ServerGame.this.closing) {
                    if (this.queue.length > 0) {
                        i = 0;
                        while (i < this.queue.length) {
                            this.writeToStream(this.queue[i]);
                            ++i;
                        }
                        this.resetQueue();
                        ServerGame.this.dos.flush();
                        continue;
                    }
                    Thread.sleep(50L);
                }
            }
            catch (Exception e) {
                ServerGame.this.quitServer(((ServerGame)ServerGame.this).cc.langBundle.getText("ServerGame.error.conLost"));
            }
        }

        private void writeToStream(Packet packet) throws IOException {
            if (packet == null) {
                return;
            }
            ServerGame.this.dos.write(packet.getPacketId());
            packet.writeData(ServerGame.this.dos);
        }

        public void sendPacket(Packet packet) {
            Packet[] newQueue = new Packet[this.queue.length + 1];
            System.arraycopy(this.queue, 0, newQueue, 0, this.queue.length);
            this.queue = newQueue;
            this.queue[this.queue.length - 1] = packet;
        }
    }
}

