/*
 * Decompiled with CFR 0.152.
 */
package net.comcraft.src;

import com.google.minijoe.sys.JsArray;
import com.google.minijoe.sys.JsObject;

public final class Vec3D
extends JsObject {
    public float x;
    public float y;
    public float z;
    private static final int ID_SET_COMPONENTS = 100;
    private static final int ID_SUBTRACT_VECTOR = 101;
    private static final int ID_NORMALIZE = 102;
    private static final int ID_DOT_PRODUCT = 103;
    private static final int ID_CROSS_PRODUCT = 104;
    private static final int ID_ADD_VECTOR = 105;
    private static final int ID_DISTANCE_TO = 106;
    private static final int ID_SQUARE_DISTANCE_TO = 107;
    private static final int ID_LENGTH_VECTOR = 108;
    private static final int ID_COPY = 109;
    private static final int ID_INNER_PRODUCT = 110;
    public static final int ID_CONSTRUCT = 111;
    private static final int ID_X = 112;
    private static final int ID_Y = 114;
    private static final int ID_Z = 116;
    public static final JsObject VEC3D_PROTOTYPE = new JsObject(JsObject.OBJECT_PROTOTYPE).addNative("setComponents", 100, 3).addNative("subtractVector", 101, 1).addNative("normalize", 102, 0).addNative("dotProduct", 103, 1).addNative("crossProduct", 104, 1).addNative("addVector", 105, 3).addNative("distanceTo", 106, 1).addNative("squareDistanceTo", 107, 1).addNative("lengthVector", 108, 0).addNative("copy", 109, 1).addNative("innerProduct", 110, 1).addNative("x", 112, -1).addNative("y", 114, -1).addNative("z", 116, -1);

    public Vec3D() {
        super(VEC3D_PROTOTYPE);
    }

    public Vec3D(float x, float y, float z) {
        this();
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public Vec3D(Vec3D vec) {
        this();
        this.x = vec.x;
        this.y = vec.y;
        this.z = vec.z;
    }

    public Vec3D setComponents(float x, float y, float z) {
        this.x = x;
        this.y = y;
        this.z = z;
        return this;
    }

    public Vec3D subtractVector(Vec3D vec3D) {
        return new Vec3D(vec3D.x - this.x, vec3D.y - this.y, vec3D.z - this.z);
    }

    public Vec3D normalize() {
        float length = this.lengthVector();
        if (length < 1.0E-4f) {
            return new Vec3D(0.0f, 0.0f, 0.0f);
        }
        return new Vec3D(this.x / length, this.y / length, this.z / length);
    }

    public double dotProduct(Vec3D vec3D) {
        return this.x * vec3D.x + this.y * vec3D.y + this.z * vec3D.z;
    }

    public Vec3D crossProduct(Vec3D vec3D) {
        return new Vec3D(this.y * vec3D.z - this.z * vec3D.y, this.z * vec3D.x - this.x * vec3D.z, this.x * vec3D.y - this.y * vec3D.x);
    }

    public Vec3D crossProduct(float t) {
        return new Vec3D(this.x * t, this.y * t, this.z * t);
    }

    public Vec3D addVector(float x, float y, float z) {
        return new Vec3D(x + x, y + y, z + z);
    }

    public Vec3D addVector(Vec3D vec) {
        return new Vec3D(this.x + vec.x, this.y + vec.y, this.z + vec.z);
    }

    public float distanceTo(Vec3D vec3D) {
        float f = vec3D.x - this.x;
        float f1 = vec3D.y - this.y;
        float f2 = vec3D.z - this.z;
        return (float)Math.sqrt(f * f + f1 * f1 + f2 * f2);
    }

    public double squareDistanceTo(Vec3D vec3D) {
        float f = vec3D.x - this.x;
        float f1 = vec3D.y - this.y;
        float f2 = vec3D.z - this.z;
        return f * f + f1 * f1 + f2 * f2;
    }

    public float lengthVector() {
        return (float)Math.sqrt(this.x * this.x + this.y * this.y + this.z * this.z);
    }

    public void copy(Vec3D vec) {
        this.x = vec.x;
        this.y = vec.y;
        this.z = vec.z;
    }

    public float innerProduct(Vec3D vec) {
        return this.x * vec.x + this.y * vec.y + this.z * vec.z;
    }

    public Vec3D subtractVector() {
        Vec3D res = new Vec3D();
        res.x = -this.x;
        res.y = -this.y;
        res.z = -this.z;
        return res;
    }

    public String toString() {
        return "Vec3D(x=" + this.x + ", y=" + this.y + ", z=" + this.z + ")";
    }

    public void evalNative(int id, JsArray stack, int sp, int parCount) {
        switch (id) {
            case 112: {
                stack.setNumber(sp, (double)this.x);
                break;
            }
            case 113: {
                this.x = (float)stack.getNumber(sp);
                break;
            }
            case 114: {
                stack.setNumber(sp, (double)this.y);
                break;
            }
            case 115: {
                this.y = (float)stack.getNumber(sp);
                break;
            }
            case 116: {
                stack.setNumber(sp, (double)this.z);
                break;
            }
            case 117: {
                this.z = (float)stack.getNumber(sp);
                break;
            }
            case 100: {
                stack.setObject(sp, (Object)this.setComponents((float)stack.getNumber(sp + 2), (float)stack.getNumber(sp + 3), (float)stack.getNumber(sp + 4)));
                break;
            }
            case 101: {
                Object object = stack.getObject(sp + 2);
                if (object instanceof Vec3D) {
                    stack.setObject(sp, (Object)this.subtractVector((Vec3D)object));
                    break;
                }
                stack.setObject(sp, (Object)this.subtractVector());
                break;
            }
            case 102: {
                stack.setObject(sp, (Object)this.normalize());
                break;
            }
            case 103: {
                stack.setNumber(sp, this.dotProduct((Vec3D)stack.getObject(sp + 2)));
                break;
            }
            case 104: {
                Object object = stack.getObject(sp + 2);
                if (object instanceof Vec3D) {
                    stack.setObject(sp, (Object)this.crossProduct((Vec3D)object));
                    break;
                }
                stack.setObject(sp, (Object)this.crossProduct((float)stack.getNumber(sp + 2)));
                break;
            }
            case 105: {
                Object object = stack.getObject(sp + 2);
                if (object instanceof Vec3D) {
                    stack.setObject(sp, (Object)this.addVector((Vec3D)object));
                    break;
                }
                stack.setObject(sp, (Object)this.addVector((float)stack.getNumber(sp + 2), (float)stack.getNumber(sp + 3), (float)stack.getNumber(sp + 4)));
                break;
            }
            case 106: {
                stack.setNumber(sp, (double)this.distanceTo((Vec3D)stack.getObject(sp + 2)));
                break;
            }
            case 107: {
                stack.setNumber(sp, this.squareDistanceTo((Vec3D)stack.getObject(sp + 2)));
                break;
            }
            case 108: {
                stack.setNumber(sp, (double)this.lengthVector());
                break;
            }
            case 109: {
                this.copy((Vec3D)stack.getObject(sp + 2));
                break;
            }
            case 110: {
                stack.setNumber(sp, (double)this.innerProduct((Vec3D)stack.getObject(sp + 2)));
                break;
            }
            case 111: {
                this.x = (float)stack.getNumber(sp + 2);
                this.y = (float)stack.getNumber(sp + 3);
                this.z = (float)stack.getNumber(sp + 4);
                break;
            }
            default: {
                super.evalNative(id, stack, sp, parCount);
            }
        }
    }
}

