/*
 * Decompiled with CFR 0.152.
 */
package net.comcraft.src;

import java.io.IOException;
import javax.microedition.io.Connector;
import javax.microedition.io.file.FileConnection;
import net.comcraft.client.Comcraft;
import net.comcraft.src.ChunkGenerator;
import net.comcraft.src.ChunkGeneratorFlat;
import net.comcraft.src.ChunkGeneratorNormal;
import net.comcraft.src.ChunkLoader;
import net.comcraft.src.ComcraftException;
import net.comcraft.src.EntityPlayer;
import net.comcraft.src.LocalChunkLoader;
import net.comcraft.src.ModAPI;
import net.comcraft.src.SaveInfo;
import net.comcraft.src.WorldInfo;
import net.comcraft.src.WorldSaveType;

public class WorldGenerator {
    private Comcraft cc;
    private String worldName;
    private WorldSaveType worldSaveType;
    private long seed;
    private SaveInfo saveHandler;
    private ChunkLoader chunkLoader;
    private int worldSize;
    private boolean isFlat;
    private int flatLevel;
    private ChunkGenerator chunkGenerator;
    private boolean generateTrees;
    private boolean allowcommands;

    public WorldGenerator(Comcraft cc, String name, int worldSize, boolean isFlat, int flatLevel, boolean generateTrees) {
        this.cc = cc;
        this.worldName = name;
        this.saveHandler = cc.worldLoader.getSaveLoader(this.worldName);
        this.worldSize = worldSize;
        this.isFlat = isFlat;
        this.flatLevel = flatLevel;
        this.generateTrees = generateTrees;
        try {
            FileConnection file = (FileConnection)Connector.open((String)this.saveHandler.getSavePath(), (int)3);
            if (!file.exists()) {
                file.mkdir();
            }
            file.close();
        }
        catch (IOException ex) {
            throw new ComcraftException(ex);
        }
        this.chunkLoader = this.saveHandler.getChunkLoader(null);
    }

    public WorldSaveType generateAndSaveWorld(boolean allowcommands) {
        this.cc.loadingScreen.displayLoadingScreen(this.cc.langBundle.getText("WorldGenereator.generatingWorld"));
        this.seed = System.currentTimeMillis();
        this.chunkGenerator = this.isFlat ? new ChunkGeneratorFlat(this.seed, this.flatLevel) : new ChunkGeneratorNormal(this.seed, this.generateTrees);
        ModAPI.event.runEvent("World.Generate", new Object[]{new Boolean(this.isFlat), this.chunkGenerator});
        this.allowcommands = allowcommands;
        this.worldSaveType = new WorldSaveType(this.saveHandler.getSavePath());
        this.writeWorldInfo();
        this.writeWorldData();
        return this.worldSaveType;
    }

    private void writeWorldInfo() {
        EntityPlayer player = new EntityPlayer(this.cc);
        player.setPlayerOnWorldCenter(this.worldSize);
        player.commandsAllowed = this.allowcommands;
        WorldInfo worldInfo = new WorldInfo();
        worldInfo.setWorldInfo(player, this.worldSize);
        this.saveHandler.saveWorldInfo(worldInfo, player);
    }

    private void writeWorldData() {
        ((LocalChunkLoader)this.chunkLoader).startSavingBlockStorage();
        int z = 0;
        while (z < this.worldSize) {
            int x = 0;
            while (x < this.worldSize) {
                ((LocalChunkLoader)this.chunkLoader).saveBlockStorage(this.chunkGenerator.generateChunk(x, z));
                ++x;
            }
            this.cc.loadingScreen.setProgress((float)z / (float)(this.worldSize - 1));
            ++z;
        }
        ((LocalChunkLoader)this.chunkLoader).endSavingBlockStorage();
        this.chunkLoader.onChunkLoaderEnd();
    }
}

