/*
 * Decompiled with CFR 0.152.
 */
package net.comcraft.src;

import java.io.IOException;
import java.util.Vector;
import javax.microedition.io.Connector;
import javax.microedition.io.file.FileConnection;
import net.comcraft.client.Comcraft;
import net.comcraft.src.ComcraftException;
import net.comcraft.src.FileSystemHelper;
import net.comcraft.src.SaveInfo;
import net.comcraft.src.WorldSaveType;

public final class WorldLoader {
    private final Comcraft cc;
    private Vector worldList;
    private String savesPath;

    public WorldLoader(Comcraft cc) {
        this.cc = cc;
        this.worldList = new Vector();
    }

    public SaveInfo getSaveLoader(String worldName) {
        return new SaveInfo(String.valueOf(this.savesPath) + worldName + "/");
    }

    public void updateAvailableWorldList() {
        try {
            this.savesPath = this.cc.settings.getComcraftFileSystem().getPathToFolder("saves/");
            this.worldList.removeAllElements();
            if (!this.cc.settings.getComcraftFileSystem().isAvailable()) {
                return;
            }
            FileConnection fileConnection = (FileConnection)Connector.open((String)this.cc.settings.getComcraftFileSystem().getPathToFolder("saves/"), (int)1);
            Vector elements = FileSystemHelper.getElementsList(fileConnection);
            int i = 0;
            while (i < elements.size()) {
                String elementName = (String)elements.elementAt(i);
                if (elementName.endsWith("/")) {
                    this.worldList.addElement(new WorldSaveType(elementName));
                }
                ++i;
            }
            fileConnection.close();
        }
        catch (IOException ex) {
            throw new ComcraftException(ex);
        }
    }

    public Vector getWorldList() {
        return this.worldList;
    }

    public void deleteWorld(WorldSaveType worldInfo) {
        try {
            FileConnection fileConnection1 = (FileConnection)Connector.open((String)(String.valueOf(worldInfo.getWorldPath()) + "level.info"), (int)3);
            if (fileConnection1.exists()) {
                fileConnection1.delete();
            }
            fileConnection1.close();
            FileConnection fileConnection2 = (FileConnection)Connector.open((String)(String.valueOf(worldInfo.getWorldPath()) + "world.data"), (int)3);
            if (fileConnection2.exists()) {
                fileConnection2.delete();
            }
            fileConnection2.close();
            FileConnection fileConnection3 = (FileConnection)Connector.open((String)worldInfo.getWorldPath(), (int)3);
            if (fileConnection3.exists()) {
                fileConnection3.delete();
            }
            fileConnection3.close();
        }
        catch (IOException ex) {
            throw new ComcraftException(ex);
        }
    }
}

