/*
 * Decompiled with CFR 0.152.
 */
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Hashtable;
import javax.microedition.lcdui.Image;

public class ResourceManager {
    private Hashtable images = new Hashtable();
    private boolean logActive = true;
    private static ResourceManager rm;

    private ResourceManager() {
    }

    public static ResourceManager getInstance() {
        if (rm == null) {
            rm = new ResourceManager();
        }
        return rm;
    }

    public void activateLog() {
        this.logActive = true;
    }

    public void deActivateLog() {
        this.logActive = false;
    }

    public void log(String string) {
        if (this.logActive) {
            System.err.println(string);
        }
    }

    public Image getImage(String string) throws IOException {
        Image image;
        if (this.images.get(string) != null) {
            return (Image)this.images.get(string);
        }
        try {
            image = Image.createImage((String)string);
        }
        catch (IOException iOException) {
            this.log("Could not open image" + string);
            throw iOException;
        }
        this.images.put(string, image);
        return image;
    }

    public DataInputStream getResourceStream(String string) throws Exception {
        DataInputStream dataInputStream = null;
        try {
            InputStream inputStream = this.getClass().getResourceAsStream(string);
            if (inputStream == null) {
                return null;
            }
            dataInputStream = new DataInputStream(inputStream);
        }
        catch (Exception exception) {
            this.log("Exception while opening " + string);
            throw exception;
        }
        return dataInputStream;
    }
}

